/*
 * Decompiled with CFR 0.152.
 */
package cn.godmao.netty.client.base;

import cn.godmao.netty.handler.IChannelHandler;
import cn.godmao.netty.handler.IConnect;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.util.AttributeMap;
import java.time.LocalDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientBaseHandler
extends ChannelInboundHandlerAdapter
implements IChannelHandler {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final IConnect connect;

    public ClientBaseHandler(IConnect connect) {
        this.connect = connect;
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        Channel channel = ctx.channel();
        this.connect.getChannelService().bind(channel, channel.id());
        this.connect.getChannelService().execute((AttributeMap)channel, () -> this.connect.onOpen(ctx));
        super.channelActive(ctx);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        this.connect.getChannelService().execute((AttributeMap)ctx.channel(), () -> this.connect.onError(ctx, cause));
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.connect.getChannelService().execute((AttributeMap)ctx.channel(), () -> this.connect.onClose(ctx));
        super.channelInactive(ctx);
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        this.connect.getChannelService().execute((AttributeMap)ctx.channel(), () -> this.connect.onMessage(ctx, msg));
        super.channelRead(ctx, msg);
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (IdleStateEvent.FIRST_ALL_IDLE_STATE_EVENT.equals(evt)) {
            this.log.debug("FIRST_ALL_IDLE_STATE_EVENT {}", evt);
        } else if (IdleStateEvent.WRITER_IDLE_STATE_EVENT.equals(evt)) {
            this.log.debug("WRITER_IDLE_STATE_EVENT {} {}", (Object)LocalDateTime.now(), evt);
        } else if (IdleStateEvent.ALL_IDLE_STATE_EVENT.equals(evt)) {
            this.log.debug("ALL_IDLE_STATE_EVENT {}", evt);
        } else if (IdleStateEvent.FIRST_READER_IDLE_STATE_EVENT.equals(evt)) {
            this.log.debug("FIRST_READER_IDLE_STATE_EVENT {}", evt);
        } else if (IdleStateEvent.FIRST_WRITER_IDLE_STATE_EVENT.equals(evt)) {
            this.log.debug("FIRST_WRITER_IDLE_STATE_EVENT {}", evt);
        } else if (IdleStateEvent.READER_IDLE_STATE_EVENT.equals(evt)) {
            this.log.debug("READER_IDLE_STATE_EVENT {}", evt);
        } else {
            this.log.debug("IDLE_STATE_EVENT {}", evt);
        }
        super.userEventTriggered(ctx, evt);
    }
}

