/*
 * Decompiled with CFR 0.152.
 */
package cn.godmao.netty.client;

import cn.godmao.netty.ChannelService;
import cn.godmao.netty.NTP;
import cn.godmao.netty.NettyUtil;
import cn.godmao.netty.client.base.ClientBaseInitializer;
import cn.godmao.netty.handler.IConnect;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.util.NettyRuntime;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractClient
implements IConnect {
    public final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Bootstrap boot = new Bootstrap();
    private final EventLoopGroup group = NettyUtil.newEventLoopGroup(NettyRuntime.availableProcessors(), "client-work-loop-group");
    private final ChannelService channelService = new ChannelService("client");
    private ChannelInitializer<Channel> channelInitializer;

    @Override
    public void start() {
        if (null == this.channelInitializer) {
            this.channelInitializer = new ClientBaseInitializer(this);
        }
        this.init();
    }

    private void init() {
        this.boot.group(this.group);
        this.boot.option(ChannelOption.SO_KEEPALIVE, (Object)true);
        this.boot.option(ChannelOption.TCP_NODELAY, (Object)true);
        this.boot.channel(NettyUtil.getSocketChannelClass(NTP.TCP));
        this.boot.handler(this.channelInitializer);
    }

    public ChannelFuture connect(String uri) {
        return this.connect(URI.create(uri));
    }

    public ChannelFuture connect(URI uri) {
        return this.connect(uri.getHost(), uri.getPort());
    }

    public ChannelFuture connect(String host, int port) {
        return this.connect(new InetSocketAddress(host, -1 == port ? 443 : port));
    }

    public ChannelFuture connect(SocketAddress address) {
        ChannelFuture channelFuture_ = this.boot.connect(address);
        channelFuture_.channel().closeFuture().addListener((GenericFutureListener)((ChannelFutureListener)channelFutureClose -> {
            this.log.info("connect: {} status: {}", (Object)address.toString(), (Object)(!channelFutureClose.isSuccess() ? 1 : 0));
            if (channelFutureClose.isSuccess()) {
                channelFutureClose.channel().eventLoop().schedule(() -> this.connect(address), 3L, TimeUnit.SECONDS);
            }
        }));
        return channelFuture_;
    }

    @Override
    public ChannelService getChannelService() {
        return this.channelService;
    }

    public void setChannelInitializer(ChannelInitializer<Channel> channelInitializer) {
        this.channelInitializer = channelInitializer;
    }
}

