/*
 * Decompiled with CFR 0.152.
 */
package cn.godmao.netty.server.base;

import cn.godmao.netty.handler.IConnect;
import cn.godmao.netty.server.base.WebsocketServerBaseDecoderHandler;
import cn.godmao.netty.server.base.WebsocketServerBaseEncoderHandler;
import cn.godmao.netty.server.base.WebsocketServerBaseHandler;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.websocketx.WebSocketServerProtocolConfig;
import io.netty.handler.codec.http.websocketx.WebSocketServerProtocolHandler;
import io.netty.handler.codec.http.websocketx.extensions.compression.WebSocketServerCompressionHandler;
import io.netty.handler.stream.ChunkedWriteHandler;
import io.netty.util.concurrent.EventExecutorGroup;

public class WebsocketServerBaseInitializer
extends ChannelInitializer<Channel> {
    public static final WebsocketServerBaseDecoderHandler serverBaseDecoderHandler = new WebsocketServerBaseDecoderHandler();
    public static final WebsocketServerBaseEncoderHandler serverBaseEncoderHandler = new WebsocketServerBaseEncoderHandler();
    public static final EventExecutorGroup eventExecutorGroup_decode = null;
    public static final EventExecutorGroup eventExecutorGroup_encode = null;
    private final String websocketPath;
    private final IConnect connect;

    public WebsocketServerBaseInitializer(String websocketPath, IConnect connect) {
        this.websocketPath = websocketPath;
        this.connect = connect;
    }

    protected void initChannel(Channel ch) {
        ChannelPipeline pipeline = ch.pipeline();
        pipeline.addLast(new ChannelHandler[]{new HttpServerCodec()});
        pipeline.addLast(new ChannelHandler[]{new HttpObjectAggregator(65536)});
        pipeline.addLast(new ChannelHandler[]{new ChunkedWriteHandler()});
        pipeline.addLast(new ChannelHandler[]{new WebSocketServerCompressionHandler()});
        pipeline.addLast(new ChannelHandler[]{new WebSocketServerProtocolHandler(WebSocketServerProtocolConfig.newBuilder().websocketPath(this.websocketPath).maxFramePayloadLength(0x100000).checkStartsWith(true).allowExtensions(true).build())});
        int index = 0;
        pipeline.addLast(eventExecutorGroup_decode, "decode-" + ++index, (ChannelHandler)serverBaseDecoderHandler);
        pipeline.addLast(eventExecutorGroup_encode, "encode-" + ++index, (ChannelHandler)serverBaseEncoderHandler);
        pipeline.addLast("servic" + ++index, (ChannelHandler)new WebsocketServerBaseHandler(this.connect));
    }
}

