/*
 * Decompiled with CFR 0.152.
 */
package cn.godmao.netty;

import cn.godmao.core.ISchedule;
import cn.godmao.executor.IExecutorGroup;
import io.netty.util.NettyRuntime;
import io.netty.util.concurrent.DefaultEventExecutor;
import io.netty.util.concurrent.DefaultThreadFactory;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.EventExecutorGroup;
import io.netty.util.concurrent.MultithreadEventExecutorGroup;
import io.netty.util.concurrent.ScheduledFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadFactory;

public class ExecutorGroup
extends MultithreadEventExecutorGroup
implements IExecutorGroup<EventExecutor>,
ISchedule<ScheduledFuture<?>> {
    private EventExecutor[] executors;
    private int size;

    public ExecutorGroup() {
        this(NettyRuntime.availableProcessors());
    }

    public ExecutorGroup(int threads) {
        this(threads, null);
    }

    public ExecutorGroup(String threadName) {
        this(threadName, NettyRuntime.availableProcessors());
    }

    public ExecutorGroup(String threadName, int threads) {
        this(threads, (ThreadFactory)new DefaultThreadFactory(threadName, false));
    }

    public ExecutorGroup(int threads, ThreadFactory threadFactory) {
        super(threads, threadFactory, new Object[0]);
    }

    public int getSize() {
        return this.size;
    }

    protected EventExecutor newChild(Executor executor, Object ... args) {
        if (null == this.executors) {
            this.executors = new EventExecutor[this.executorCount()];
        }
        DefaultEventExecutor eventExecutor = new DefaultEventExecutor((EventExecutorGroup)this, executor);
        this.executors[this.size++] = eventExecutor;
        return eventExecutor;
    }

    public EventExecutor[] getExecutors() {
        return this.executors;
    }
}

