/*
 * Decompiled with CFR 0.152.
 */
package cn.godmao.netty;

import cn.godmao.netty.ExecutorGroup;
import cn.godmao.utils.CollectUtil;
import cn.godmao.utils.ObjectUtil;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelOutboundInvoker;
import io.netty.channel.group.ChannelGroupFuture;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.util.AttributeKey;
import io.netty.util.AttributeMap;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.GlobalEventExecutor;
import java.util.Collection;
import java.util.function.Function;

public class ChannelService
extends DefaultChannelGroup {
    public static final AttributeKey<EventExecutor> CHANNELEXECUTOR = AttributeKey.valueOf((String)"channel-executor");
    public static final AttributeKey<Object> CHANNELID = AttributeKey.valueOf((String)"channel-id");
    private final ExecutorGroup executorGroup = new ExecutorGroup(this.name() + "-channel-group");

    public ChannelService(String name) {
        super(name, (EventExecutor)GlobalEventExecutor.INSTANCE);
    }

    public ExecutorGroup getExecutorGroup() {
        return this.executorGroup;
    }

    public void bind(Channel channel, Object id) {
        ObjectUtil.checkNotNull((Object)id, (String)CHANNELID.name());
        boolean add = this.add(channel);
        channel.attr(CHANNELID).set(id);
        channel.attr(CHANNELEXECUTOR).set((Object)((EventExecutor)this.executorGroup.select(id)));
    }

    public void execute(AttributeMap attributeMap, Runnable runnable) {
        this.getChannelExecutor(attributeMap).execute(runnable);
    }

    public Object getChannelId(AttributeMap attributeMap) {
        return attributeMap.attr(CHANNELID).get();
    }

    public EventExecutor getChannelExecutor(AttributeMap attributeMap) {
        return (EventExecutor)attributeMap.attr(CHANNELEXECUTOR).get();
    }

    public ChannelFuture writeAndFlush(Object message, ChannelOutboundInvoker channelOutboundInvoker) {
        return channelOutboundInvoker.writeAndFlush(message);
    }

    public <T> ChannelGroupFuture writeAndFlush(Object message, Function<Channel, T> function, Collection<T> collection) {
        return this.writeAndFlush(message, channel -> collection.contains(function.apply(channel)));
    }

    public <T> ChannelGroupFuture writeAndFlush(Object message, Function<Channel, T> function, T ... collection) {
        return this.writeAndFlush(message, channel -> CollectUtil.contains((Object[])collection, function.apply(channel)));
    }
}

