package cn.godmao.netty.server.base;

import cn.godmao.netty.handler.IChannelHandler;
import cn.godmao.netty.handler.IConnect;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.timeout.IdleStateEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.time.LocalDateTime;

public class WebsocketServerBaseHandler extends ChannelInboundHandlerAdapter implements IChannelHandler {
    private final Logger   log = LoggerFactory.getLogger(this.getClass());
    private final IConnect connect;

    public WebsocketServerBaseHandler(IConnect connect) {
        this.connect = connect;
    }


    @Override
    public void channelActive(ChannelHandlerContext ctx) throws Exception {
//        log.info("channelActive {}", ctx.channel().id());
        Channel channel = ctx.channel();
        connect.getChannelService().bind(channel, channel.id());
        connect.getChannelService().execute(channel, () -> connect.onOpen(ctx));
        super.channelActive(ctx);
    }


    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        connect.getChannelService().execute(ctx.channel(), () -> connect.onError(ctx, cause));
    }


    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        connect.getChannelService().execute(ctx.channel(), () -> connect.onClose(ctx));
        super.channelInactive(ctx);
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
//        log.info("channelRead {} {}", ctx.channel().id(), msg);
        connect.getChannelService().execute(ctx.channel(), () -> connect.onMessage(ctx, msg));
        super.channelRead(ctx, msg);
    }


    @Override
    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (IdleStateEvent.FIRST_ALL_IDLE_STATE_EVENT.equals(evt)) {
            log.debug("FIRST_ALL_IDLE_STATE_EVENT {}", evt);
//            NettyUtil.close(ctx.channel());
        } else if (IdleStateEvent.WRITER_IDLE_STATE_EVENT.equals(evt)) {
            log.debug("WRITER_IDLE_STATE_EVENT {} {}", LocalDateTime.now(), evt);
        } else if (IdleStateEvent.ALL_IDLE_STATE_EVENT.equals(evt)) {
            log.debug("ALL_IDLE_STATE_EVENT {}", evt);
        } else if (IdleStateEvent.FIRST_READER_IDLE_STATE_EVENT.equals(evt)) {
            log.debug("FIRST_READER_IDLE_STATE_EVENT {}", evt);
        } else if (IdleStateEvent.FIRST_WRITER_IDLE_STATE_EVENT.equals(evt)) {
            log.debug("FIRST_WRITER_IDLE_STATE_EVENT {}", evt);
        } else if (IdleStateEvent.READER_IDLE_STATE_EVENT.equals(evt)) {
            log.debug("READER_IDLE_STATE_EVENT {}", evt);
        } else {
            log.debug("IDLE_STATE_EVENT {}", evt);
        }
        super.userEventTriggered(ctx, evt);
    }
}
