package cn.godmao.netty.example;

import cn.godmao.netty.client.AbstractClient;
import cn.godmao.netty.client.base.WebsocketClientBaseInitializer;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;

public class Client extends AbstractClient {
    public Client() {
        setChannelInitializer(new WebsocketClientBaseInitializer());
    }

    @Override
    public void onOpen(ChannelHandlerContext ctx) {
        Channel channel = ctx.channel();

        log.info("{} {}", channel.id(), "连上了");
//        for (int i = 0; i < 1000000; i++) {
//            //
//            // 高低水位线
////            channel.isActive() && channel.isWritable()
//            getChannelService().writeAndFlush("我曹", ctx);
////            channel.writeAndFlush("撒旦圣斗士多");
//        }
        getChannelService().writeAndFlush("我曹", ctx);
    }

    @Override
    public void onClose(ChannelHandlerContext ctx) {
        log.info("{} {}", ctx.channel().id(), "断开了");
    }

    @Override
    public void onError(ChannelHandlerContext ctx, Throwable throwable) {
        log.info(ctx.channel().id().asLongText(), throwable);
    }

    @Override
    public void onMessage(ChannelHandlerContext ctx, Object message) {
        log.info("来消息了 {}", message);
    }

    public static void main(String[] args) throws InterruptedException {
        Client client = new Client();
        client.start();
        // -Dio.netty.leakDetection.level=paranoid

        // 一共是10个连接 单个连接100万消息并发 总的消息并发就是1000万 看一下服务端接受到100万消息的时间计算
        client.connect("wss://gdwsnew.hongtonggames.com/guandan");
//        client.connect("127.0.0.1", 15122);
//        client.connect("127.0.0.1", 15122);
//        client.connect("127.0.0.1", 15122);
//        client.connect("127.0.0.1", 15122);
//        client.connect("127.0.0.1", 15122);
//        client.connect("127.0.0.1", 15122);
//        client.connect("127.0.0.1", 15122);
//        client.connect("127.0.0.1", 15122);
//        client.connect("127.0.0.1", 15122);

    }
}
