package cn.godmao.netty.client.base;

import cn.godmao.netty.handler.IConnect;
import io.netty.channel.Channel;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import io.netty.handler.codec.string.StringDecoder;
import io.netty.handler.codec.string.StringEncoder;
import io.netty.util.concurrent.EventExecutorGroup;

public class ClientBaseInitializer extends ChannelInitializer<Channel> {
    //    public static final LengthFieldBasedFrameDecoder lengthFieldBasedFrameDecoder = new LengthFieldBasedFrameDecoder(1024 * 1024, 0, 4, -4, 0);
    //    public static final StringDecoder clientStringDecoder = new StringDecoder();
    public static final ClientBaseDecoderHandler clientBaseDecoderHandler = new ClientBaseDecoderHandler();
    //    public static final StringEncoder clientStringEncoder = new StringEncoder();
    public static final ClientBaseEncoderHandler clientBaseEncoderHandler = new ClientBaseEncoderHandler();

    //
    public static final EventExecutorGroup eventExecutorGroup_unpacker = null/*NettyUtil.newEventLoopGroup("unpacker")*/;
    public static final EventExecutorGroup eventExecutorGroup_decode   = null/*NettyUtil.newEventLoopGroup("decode")*/;
    public static final EventExecutorGroup eventExecutorGroup_encode   = null/*NettyUtil.newEventLoopGroup("encode")*/;

    //
    private final IConnect connect;

    public ClientBaseInitializer(IConnect connect) {
        this.connect = connect;
    }

    @Override
    protected void initChannel(Channel ch) {
        ChannelPipeline pipeline = ch.pipeline();
        int index = 0;
        // 拆包器
        // 参数二：长度在buf中的偏移量，因为我在buf中先写的是长度，所以长度的偏移量是0，如果先写入2个字节的数据，再写入长度，那么长度的偏移量就是2
        // 参数三：长度占用的字节，我写的是一个int类型，占用4个字节
        // 参数四：需要调整的长度
        // 参数五：数据从头开始需要剥离的长度，现在buf中的数据是 ....hello, world 和 ....hi!，前面的4个点是长度，我们不需要长度，所以需要把长度剥离出去
        pipeline.addLast(eventExecutorGroup_unpacker, "unpacker-" + ++index, new LengthFieldBasedFrameDecoder(1024 * 1024, 0, 4, -4, 0));
        // 解码器
//        pipeline.addLast(eventExecutorGroup_decode, "decode-" + ++index, clientStringDecoder);
        pipeline.addLast(eventExecutorGroup_decode, "decode-" + ++index, clientBaseDecoderHandler);
        // 编码器
        pipeline.addLast(eventExecutorGroup_encode, "encode-" + ++index, clientBaseEncoderHandler);
//        pipeline.addLast(eventExecutorGroup_encode, "encode-" + ++index, clientStringEncoder);
        // 业务处理器
        pipeline.addLast("service-" + ++index, new ClientBaseHandler(connect));
    }

}