/*
 * Decompiled with CFR 0.152.
 */
package cn.godmao.netty.client.base;

import cn.godmao.netty.ChannelService;
import cn.godmao.netty.client.AbstractClient;
import cn.godmao.netty.handler.IChannelHandler;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.util.AttributeMap;
import java.time.LocalDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientBaseHandler
extends ChannelInboundHandlerAdapter
implements IChannelHandler {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final AbstractClient client;
    private final ChannelService channelService;

    public ClientBaseHandler(AbstractClient client) {
        this.client = client;
        this.channelService = client.getChannelService();
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        Channel channel = ctx.channel();
        this.channelService.bind(channel.id().asLongText(), channel);
        this.channelService.execute((AttributeMap)channel, () -> this.client.onOpen(ctx));
        super.channelActive(ctx);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        this.channelService.execute((AttributeMap)ctx.channel(), () -> this.client.onError(ctx, cause));
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.channelService.execute((AttributeMap)ctx.channel(), () -> this.client.onClose(ctx));
        super.channelInactive(ctx);
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        this.channelService.execute((AttributeMap)ctx.channel(), () -> this.client.onMessage(ctx, msg));
        super.channelRead(ctx, msg);
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (IdleStateEvent.FIRST_ALL_IDLE_STATE_EVENT.equals(evt)) {
            this.log.debug("FIRST_ALL_IDLE_STATE_EVENT {}", evt);
        } else if (IdleStateEvent.WRITER_IDLE_STATE_EVENT.equals(evt)) {
            this.log.debug("WRITER_IDLE_STATE_EVENT {} {}", (Object)LocalDateTime.now(), evt);
        } else if (IdleStateEvent.ALL_IDLE_STATE_EVENT.equals(evt)) {
            this.log.debug("ALL_IDLE_STATE_EVENT {}", evt);
        } else if (IdleStateEvent.FIRST_READER_IDLE_STATE_EVENT.equals(evt)) {
            this.log.debug("FIRST_READER_IDLE_STATE_EVENT {}", evt);
        } else if (IdleStateEvent.FIRST_WRITER_IDLE_STATE_EVENT.equals(evt)) {
            this.log.debug("FIRST_WRITER_IDLE_STATE_EVENT {}", evt);
        } else if (IdleStateEvent.READER_IDLE_STATE_EVENT.equals(evt)) {
            this.log.debug("READER_IDLE_STATE_EVENT {}", evt);
        } else {
            this.log.debug("IDLE_STATE_EVENT {}", evt);
        }
        super.userEventTriggered(ctx, evt);
    }
}

