package cn.godmao.netty.server.base;

import cn.godmao.netty.server.AbstractServer;
import io.netty.channel.Channel;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.websocketx.WebSocketServerProtocolConfig;
import io.netty.handler.codec.http.websocketx.WebSocketServerProtocolHandler;
import io.netty.handler.codec.http.websocketx.extensions.compression.WebSocketServerCompressionHandler;
import io.netty.handler.stream.ChunkedWriteHandler;
import io.netty.util.concurrent.EventExecutorGroup;

public class WebsocketServerBaseInitializer extends ChannelInitializer<Channel> {

    public static final WebsocketServerBaseDecoderHandler serverBaseDecoderHandler = new WebsocketServerBaseDecoderHandler();
    //    public static final StringEncoder serverStringEncoder = new StringEncoder();
    public static final WebsocketServerBaseEncoderHandler serverBaseEncoderHandler = new WebsocketServerBaseEncoderHandler();
    
    //
    public static final EventExecutorGroup eventExecutorGroup_decode = null;
    public static final EventExecutorGroup eventExecutorGroup_encode = null;

    //
    private final String         websocketPath;
    private final AbstractServer server;

    public WebsocketServerBaseInitializer(String websocketPath, AbstractServer server) {
        this.websocketPath = websocketPath;
        this.server = server;
    }

    @Override
    protected void initChannel(Channel ch) {
        ChannelPipeline pipeline = ch.pipeline();

        // websocket
        pipeline.addLast(new HttpServerCodec());
        pipeline.addLast(new HttpObjectAggregator(65536));
        pipeline.addLast(new ChunkedWriteHandler());
        pipeline.addLast(new WebSocketServerCompressionHandler());
        pipeline.addLast(new WebSocketServerProtocolHandler(
                WebSocketServerProtocolConfig.newBuilder()
                        // 验证 URL
                        .websocketPath(websocketPath)
                        // 默认数据包大小
                        .maxFramePayloadLength(1024 * 1024)
                        .checkStartsWith(true)
                        // 开启 WebSocket 扩展
                        .allowExtensions(true).build())
        );

        //
        int index = 0;

        // 解码器
//        pipeline.addLast(eventExecutorGroup_decode, "decode-" + ++index, serverStringDecoder);
        pipeline.addLast(eventExecutorGroup_decode, "decode-" + ++index, serverBaseDecoderHandler);
        // 编码器
        pipeline.addLast(eventExecutorGroup_encode, "encode-" + ++index, serverBaseEncoderHandler);
        // 业务处理器
        pipeline.addLast("servic" + ++index, new WebsocketServerBaseHandler(server));
    }
}
