package cn.godmao.netty.server.base;

import cn.godmao.netty.ChannelService;
import cn.godmao.netty.handler.IChannelHandler;
import cn.godmao.netty.server.AbstractServer;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.timeout.IdleStateEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.time.LocalDateTime;

public class ServerBaseHandler extends ChannelInboundHandlerAdapter implements IChannelHandler {
    private final Logger         log = LoggerFactory.getLogger(this.getClass());
    private final AbstractServer server;
    private final ChannelService channelService;

    public ServerBaseHandler(AbstractServer server) {
        this.server = server;
        this.channelService = server.getChannelService();
    }


    @Override
    public void channelActive(ChannelHandlerContext ctx) throws Exception {
//        log.info("channelActive {}", ctx.channel().id());
        Channel channel = ctx.channel();
        channelService.bind(channel, channel.id());
        channelService.execute(channel, () -> server.onOpen(ctx));
        super.channelActive(ctx);
    }


    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        channelService.execute(ctx.channel(), () -> server.onError(ctx, cause));
    }


    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        channelService.execute(ctx.channel(), () -> server.onClose(ctx));
        super.channelInactive(ctx);
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
//        log.info("channelRead {} {}", ctx.channel().id(), msg);
        channelService.execute(ctx.channel(), () -> server.onMessage(ctx, msg));
        super.channelRead(ctx, msg);
    }


    @Override
    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (IdleStateEvent.FIRST_ALL_IDLE_STATE_EVENT.equals(evt)) {
            log.debug("FIRST_ALL_IDLE_STATE_EVENT {}", evt);
//                NettyUtil.close(ctx.channel());
        } else if (IdleStateEvent.WRITER_IDLE_STATE_EVENT.equals(evt)) {
            log.debug("WRITER_IDLE_STATE_EVENT {} {}", LocalDateTime.now(), evt);
        } else if (IdleStateEvent.ALL_IDLE_STATE_EVENT.equals(evt)) {
            log.debug("ALL_IDLE_STATE_EVENT {}", evt);
        } else if (IdleStateEvent.FIRST_READER_IDLE_STATE_EVENT.equals(evt)) {
            log.debug("FIRST_READER_IDLE_STATE_EVENT {}", evt);
        } else if (IdleStateEvent.FIRST_WRITER_IDLE_STATE_EVENT.equals(evt)) {
            log.debug("FIRST_WRITER_IDLE_STATE_EVENT {}", evt);
        } else if (IdleStateEvent.READER_IDLE_STATE_EVENT.equals(evt)) {
            log.debug("READER_IDLE_STATE_EVENT {}", evt);
        } else {
            log.debug("IDLE_STATE_EVENT {}", evt);
        }
        super.userEventTriggered(ctx, evt);
    }
}
