package cn.godmao.netty.server.base;

import cn.godmao.netty.codec.DefaultEncoder;
import cn.godmao.netty.handler.AbstractEncoderHandler;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.List;

@ChannelHandler.Sharable
public class ServerBaseEncoderHandler extends AbstractEncoderHandler<Object> {
//    private final Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    protected void encode(ChannelHandlerContext ctx, Object msg, List<Object> out) {
//        log.info("{} encode", ctx.channel().id());
        ByteBuf byteBuf = DefaultEncoder.me().encode(msg);
        if (null != byteBuf) {
            out.add(byteBuf);
        }
    }
}

