package cn.godmao.netty.example;

import cn.godmao.netty.server.AbstractServer;
import cn.godmao.netty.server.base.WebsocketServerBaseInitializer;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;

public class Server extends AbstractServer {

    public Server(int port, String path) {
        super(port);
        log.info("path: {}", path);
        this.setChannelInitializer(new WebsocketServerBaseInitializer(path, this));
    }


    @Override
    public void onOpen(ChannelHandlerContext ctx) {
        log.info("{} {}", ctx.channel().id(), "连上了");
        ctx.writeAndFlush("你好");
    }

    @Override
    public void onClose(ChannelHandlerContext ctx) {
        log.info("{} {}", ctx.channel().id(), "断开了");
    }

    @Override
    public void onError(ChannelHandlerContext ctx, Throwable throwable) {
        log.info(ctx.channel().id().asLongText(), throwable);
    }

    @Override
    public void onMessage(ChannelHandlerContext ctx, Object message) {
        if (message instanceof TextWebSocketFrame) {//正常的数据
            TextWebSocketFrame textWebSocketFrame = (TextWebSocketFrame) message;
            log.info("MessageNettyHandler 客户端消息：{}", textWebSocketFrame.text());
        }
        log.info("{}", message);
    }

    public static void main(String[] args) {
        Server server = new Server(15122, "/guandan");
        server.start();
        System.out.println(1);
    }
}
