package cn.godmao.netty.codec;

import cn.godmao.utils.ProtostuffUtil;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.EncoderException;

public class DefaultEncoder implements IEncoder<Object, ByteBuf> {

    @Override
    public ByteBuf encode(Object message) throws EncoderException {
        if (null == message) {
            return null;
        }
        ByteBuf byteBuf = null;
        if (message instanceof ByteBuf) {
            byteBuf = ((ByteBuf) message).retainedDuplicate();
        } else if (message instanceof byte[]) {
            byteBuf = Unpooled.wrappedBuffer((byte[]) message);
        } else {
            final Class<?> messageClass = message.getClass();
            byte[] message_type_bytes = messageClass.getName().getBytes();
//            byte[] message_type_bytes = ProtostuffUtil.serialize(messageClass.getName());
            byte[] message_bytes = ProtostuffUtil.serialize(message);
            final int size = 8 + message_bytes.length + message_type_bytes.length;
//            byteBuf = ByteBufAllocator.DEFAULT.heapBuffer(size);
            byteBuf = ByteBufAllocator.DEFAULT.directBuffer(size);
            byteBuf.writeInt(size);
            byteBuf.writeInt(message_type_bytes.length);
            byteBuf.writeBytes(message_type_bytes);
            byteBuf.writeBytes(message_bytes);
        }
        return byteBuf;
    }


    public static DefaultEncoder me() {
        return DefaultEncoder.Holder.ME;
    }


    private static class Holder {
        static final DefaultEncoder ME = new DefaultEncoder();
    }

}