package cn.godmao.netty.client.base;

import cn.godmao.netty.ChannelService;
import cn.godmao.netty.client.AbstractClient;
import cn.godmao.netty.handler.IChannelHandler;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.timeout.IdleStateEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.time.LocalDateTime;

public class ClientBaseHandler extends ChannelInboundHandlerAdapter implements IChannelHandler {
    private final Logger         log = LoggerFactory.getLogger(this.getClass());
    private final AbstractClient client;
    private final ChannelService channelService;

    public ClientBaseHandler(AbstractClient client) {
        this.client = client;
        this.channelService = client.getChannelService();
    }


    @Override
    public void channelActive(ChannelHandlerContext ctx) throws Exception {
//        log.info("channelActive {}",ctx.channel().id());
        Channel channel = ctx.channel();
        channelService.bind(channel, channel.id());
        channelService.execute(channel, () -> client.onOpen(ctx));
        super.channelActive(ctx);
    }


    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        channelService.execute(ctx.channel(), () -> client.onError(ctx, cause));
    }


    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        channelService.execute(ctx.channel(), () -> client.onClose(ctx));
        super.channelInactive(ctx);
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        channelService.execute(ctx.channel(), () -> client.onMessage(ctx, msg));
        super.channelRead(ctx, msg);
    }


    @Override
    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (IdleStateEvent.FIRST_ALL_IDLE_STATE_EVENT.equals(evt)) {
            log.debug("FIRST_ALL_IDLE_STATE_EVENT {}", evt);
//                NettyUtil.close(ctx.channel());
        } else if (IdleStateEvent.WRITER_IDLE_STATE_EVENT.equals(evt)) {
            log.debug("WRITER_IDLE_STATE_EVENT {} {}", LocalDateTime.now(), evt);
        } else if (IdleStateEvent.ALL_IDLE_STATE_EVENT.equals(evt)) {
            log.debug("ALL_IDLE_STATE_EVENT {}", evt);
        } else if (IdleStateEvent.FIRST_READER_IDLE_STATE_EVENT.equals(evt)) {
            log.debug("FIRST_READER_IDLE_STATE_EVENT {}", evt);
        } else if (IdleStateEvent.FIRST_WRITER_IDLE_STATE_EVENT.equals(evt)) {
            log.debug("FIRST_WRITER_IDLE_STATE_EVENT {}", evt);
        } else if (IdleStateEvent.READER_IDLE_STATE_EVENT.equals(evt)) {
            log.debug("READER_IDLE_STATE_EVENT {}", evt);
        } else {
            log.debug("IDLE_STATE_EVENT {}", evt);
        }
        super.userEventTriggered(ctx, evt);
    }
}
