package cn.godmao.netty;

import cn.godmao.utils.CollectUtil;
import cn.godmao.utils.ObjectUtil;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelOutboundInvoker;
import io.netty.channel.group.ChannelGroupFuture;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.util.AttributeKey;
import io.netty.util.AttributeMap;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.GlobalEventExecutor;

import java.util.Collection;
import java.util.function.Function;

public class ChannelService extends DefaultChannelGroup {
    public static final AttributeKey<EventExecutor> CHANNELEXECUTOR = AttributeKey.valueOf("channel-executor");
    public static final AttributeKey<Object>        CHANNELID       = AttributeKey.valueOf("channel-id");
    private final       ExecutorGroup               executorGroup;

    public ChannelService(String name) {
        super(name, GlobalEventExecutor.INSTANCE);
        this.executorGroup = new ExecutorGroup((name() + "-" + "channel-group"));
    }

    public ExecutorGroup getExecutorGroup() {
        return executorGroup;
    }

    public void bind(Channel channel, Object id) {
        ObjectUtil.checkNotNull(id, CHANNELID.name());
        boolean add = add(channel);
        channel.attr(CHANNELID).set(id);
        channel.attr(CHANNELEXECUTOR).set(executorGroup.select(id));
    }

    public void execute(AttributeMap attributeMap, Runnable runnable) {
        getChannelExecutor(attributeMap).execute(runnable);
    }

    public Object getChannelId(AttributeMap attributeMap) {
        return attributeMap.attr(CHANNELID).get();
    }

    public EventExecutor getChannelExecutor(AttributeMap attributeMap) {
        return attributeMap.attr(CHANNELEXECUTOR).get();
    }

    public ChannelFuture writeAndFlush(Object message, ChannelOutboundInvoker channelOutboundInvoker) {
        return channelOutboundInvoker.writeAndFlush(message);
    }

    public <T> ChannelGroupFuture writeAndFlush(Object message, Function<Channel, T> function, Collection<T> collection) {
        return writeAndFlush(message, channel -> collection.contains(function.apply(channel)));
    }

    public <T> ChannelGroupFuture writeAndFlush(Object message, Function<Channel, T> function, T... collection) {
        return writeAndFlush(message, channel -> CollectUtil.contains(collection, function.apply(channel)));
    }
}
