/*
 * Decompiled with CFR 0.152.
 */
package cn.godmao.netty.server.base;

import cn.godmao.netty.ChannelService;
import cn.godmao.netty.handler.IChannelHandler;
import cn.godmao.netty.server.AbstractServer;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.util.AttributeMap;
import java.time.LocalDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerBaseHandler
extends ChannelInboundHandlerAdapter
implements IChannelHandler {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final AbstractServer server;
    private final ChannelService channelService;

    public ServerBaseHandler(AbstractServer server) {
        this.server = server;
        this.channelService = server.getChannelService();
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        Channel channel = ctx.channel();
        this.channelService.bind(channel.id().asLongText(), channel);
        this.channelService.execute((AttributeMap)channel, () -> this.server.onOpen(ctx));
        super.channelActive(ctx);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        this.channelService.execute((AttributeMap)ctx.channel(), () -> this.server.onError(ctx, cause));
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.channelService.execute((AttributeMap)ctx.channel(), () -> this.server.onClose(ctx));
        super.channelInactive(ctx);
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        this.channelService.execute((AttributeMap)ctx.channel(), () -> this.server.onMessage(ctx, msg));
        super.channelRead(ctx, msg);
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (IdleStateEvent.FIRST_ALL_IDLE_STATE_EVENT.equals(evt)) {
            this.log.debug("FIRST_ALL_IDLE_STATE_EVENT {}", evt);
        } else if (IdleStateEvent.WRITER_IDLE_STATE_EVENT.equals(evt)) {
            this.log.debug("WRITER_IDLE_STATE_EVENT {} {}", (Object)LocalDateTime.now(), evt);
        } else if (IdleStateEvent.ALL_IDLE_STATE_EVENT.equals(evt)) {
            this.log.debug("ALL_IDLE_STATE_EVENT {}", evt);
        } else if (IdleStateEvent.FIRST_READER_IDLE_STATE_EVENT.equals(evt)) {
            this.log.debug("FIRST_READER_IDLE_STATE_EVENT {}", evt);
        } else if (IdleStateEvent.FIRST_WRITER_IDLE_STATE_EVENT.equals(evt)) {
            this.log.debug("FIRST_WRITER_IDLE_STATE_EVENT {}", evt);
        } else if (IdleStateEvent.READER_IDLE_STATE_EVENT.equals(evt)) {
            this.log.debug("READER_IDLE_STATE_EVENT {}", evt);
        } else {
            this.log.debug("IDLE_STATE_EVENT {}", evt);
        }
        super.userEventTriggered(ctx, evt);
    }
}

