/*
 * Decompiled with CFR 0.152.
 */
package cn.godmao.netty.codec;

import cn.godmao.netty.codec.IDecoder;
import cn.godmao.utils.ClassUtil;
import cn.godmao.utils.ProtostuffUtil;
import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.DecoderException;

public class DefaultDecoder
implements IDecoder<ByteBuf, Object> {
    @Override
    public Object decode(ByteBuf byteBuf) throws DecoderException, ClassNotFoundException {
        int writerIndex;
        if (!byteBuf.isReadable()) {
            return byteBuf;
        }
        int messageSize = byteBuf.readInt();
        if (messageSize != (writerIndex = byteBuf.writerIndex())) {
            return byteBuf;
        }
        int messageSize_type = byteBuf.readInt();
        byte[] data_message_type = new byte[messageSize_type];
        byteBuf.readBytes(data_message_type);
        String message_type = new String(data_message_type);
        Class clazz = ClassUtil.forName((String)message_type);
        byte[] data_message = new byte[byteBuf.readableBytes()];
        byteBuf.readBytes(data_message);
        return ProtostuffUtil.deserialize((byte[])data_message, (Class)clazz);
    }

    public static DefaultDecoder me() {
        return Holder.ME;
    }

    private static class Holder {
        static final DefaultDecoder ME = new DefaultDecoder();

        private Holder() {
        }
    }
}

