package cn.godmao.netty.example;

import cn.godmao.netty.server.AbstractServer;
import io.netty.channel.ChannelHandlerContext;

public class Server extends AbstractServer {

    public Server(int port) {
        super(port);
    }


    @Override
    public void onOpen(ChannelHandlerContext ctx) {
        log.info("{} {}", ctx.channel().id(), "连上了");
//        channel.writeAndFlush("你好");
    }

    @Override
    public void onClose(ChannelHandlerContext ctx) {
        log.info("{} {}", ctx.channel().id(), "断开了");
    }

    @Override
    public void onError(ChannelHandlerContext ctx, Throwable throwable) {
        log.info(ctx.channel().id().asLongText(), throwable);
    }

    @Override
    public void onMessage(ChannelHandlerContext ctx, Object message) {
        Tool.acceptMessage(1000000);
    }

    public static void main(String[] args) {
        Server server = new Server(1122);
        server.start();
        System.out.println(1);
    }
}
