package cn.godmao.netty.codec;

import cn.godmao.utils.ClassUtil;
import cn.godmao.utils.ProtostuffUtil;
import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.DecoderException;

public class DefaultDecoder implements IDecoder<ByteBuf, Object> {

    @Override
    public Object decode(ByteBuf byteBuf) throws DecoderException, ClassNotFoundException {
        //
        if (!byteBuf.isReadable()) {
            return byteBuf;
        }
        final int messageSize = byteBuf.readInt();
        final int writerIndex = byteBuf.writerIndex();
        if (messageSize != writerIndex) {
            return byteBuf;
        }
        final int messageSize_type = byteBuf.readInt();
        byte[] data_message_type = new byte[messageSize_type];
        byteBuf.readBytes(data_message_type);
        final String message_type = new String(data_message_type);
//        final String message_type = ProtostuffUtil.deserialize(data_message_type, String.class);
        final Class<?> clazz = ClassUtil.forName(message_type);
        byte[] data_message = new byte[byteBuf.readableBytes()];
        byteBuf.readBytes(data_message);
        return ProtostuffUtil.deserialize(data_message, clazz);
    }

    public static DefaultDecoder me() {
        return Holder.ME;
    }


    private static class Holder {
        static final DefaultDecoder ME = new DefaultDecoder();
    }
}
