package cn.godmao.netty;

import cn.godmao.core.ISchedule;
import cn.godmao.executor.IExecutorGroup;
import io.netty.util.NettyRuntime;
import io.netty.util.concurrent.*;

import java.util.concurrent.Executor;
import java.util.concurrent.ThreadFactory;

public class ExecutorGroup extends MultithreadEventExecutorGroup implements IExecutorGroup<EventExecutor>, ISchedule<ScheduledFuture<?>> {
    private EventExecutor[] executors;
    private int             size;

    public ExecutorGroup() {
        this(NettyRuntime.availableProcessors());
    }

    public ExecutorGroup(int threads) {
        this(threads, null);
    }

    public ExecutorGroup(String threadName) {
        this(threadName, NettyRuntime.availableProcessors());
    }

    public ExecutorGroup(String threadName, int threads) {
        this(threads, new DefaultThreadFactory(threadName, false));
    }

    public ExecutorGroup(int threads, ThreadFactory threadFactory) {
        super(threads, threadFactory);
    }

    public int getSize() {
        return size;
    }

    @Override
    protected EventExecutor newChild(Executor executor, Object... args) {
        if (null == executors) {
            executors = new EventExecutor[executorCount()];
        }
        DefaultEventExecutor eventExecutor = new DefaultEventExecutor(this, executor);
        executors[size++] = eventExecutor;
        return eventExecutor;
    }

    @Override
    public EventExecutor[] getExecutors() {
        return executors;
    }
}

