package cn.godmao.netty.server.base;

import cn.godmao.netty.handler.IConnect;
import io.netty.channel.Channel;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import io.netty.handler.codec.LengthFieldPrepender;
import io.netty.handler.codec.string.StringDecoder;
import io.netty.handler.codec.string.StringEncoder;
import io.netty.util.concurrent.EventExecutorGroup;

public class ServerBaseInitializer extends ChannelInitializer<Channel> {
    //    public static final LengthFieldBasedFrameDecoder lengthFieldBasedFrameDecoder = new LengthFieldBasedFrameDecoder(1024 * 1024, 0, 4, -4, 0);
    //
//    public static final StringDecoder            serverStringDecoder         = new StringDecoder();
    public static final ServerBaseDecoderHandler serverBaseDecoderHandler    = new ServerBaseDecoderHandler();
    //    public static final StringEncoder            serverStringEncoder         = new StringEncoder();
    public static final ServerBaseEncoderHandler serverBaseEncoderHandler    = new ServerBaseEncoderHandler();
    //
    public static final EventExecutorGroup       eventExecutorGroup_unpacker = null;
    public static final EventExecutorGroup       eventExecutorGroup_decode   = null;
    public static final EventExecutorGroup       eventExecutorGroup_encode   = null;

    //
    private final IConnect connect;

    public ServerBaseInitializer(IConnect connect) {
        this.connect = connect;
    }

    @Override
    protected void initChannel(Channel ch) {
        ChannelPipeline pipeline = ch.pipeline();
        int index = 0;
        // 拆包器
        // 参数二：长度在buf中的偏移量，因为我在buf中先写的是长度，所以长度的偏移量是0，如果先写入2个字节的数据，再写入长度，那么长度的偏移量就是2
        // 参数三：长度占用的字节，我写的是一个int类型，占用4个字节
        // 参数四：需要调整的长度
        // 参数五：数据从头开始需要剥离的长度，现在buf中的数据是 ....hello, world 和 ....hi!，前面的4个点是长度，我们不需要长度，所以需要把长度剥离出去
        pipeline.addLast(eventExecutorGroup_unpacker, "unpacker-" + ++index, new LengthFieldBasedFrameDecoder(1024 * 1024, 0, 4, 0, 4));
        // LengthFieldPrepender是一个编码器，主要是在响应字节数据前面添加字节长度字段
        // 粘包器
        pipeline.addLast(new LengthFieldPrepender(4));
        // 解码器
//        pipeline.addLast(eventExecutorGroup_decode, "decode-" + ++index, serverStringDecoder);
        pipeline.addLast(eventExecutorGroup_decode, "decode-" + ++index, serverBaseDecoderHandler);
        // 编码器
        pipeline.addLast(eventExecutorGroup_encode, "encode-" + ++index, serverBaseEncoderHandler);
//        pipeline.addLast(eventExecutorGroup_encode, "encode-" + ++index, serverStringEncoder);
        // 业务处理器
        pipeline.addLast("servic" + ++index, new ServerBaseHandler(connect));


//        // index 从大到小排序
//        Collections.sort(this.channelHandlers);
//        for (int i = 0; i < this.channelHandlers.size(); i++) {
//            IChannelHandler channelHandler = this.channelHandlers.get(i);
//            boolean isSharable = false;
//            if (channelHandler instanceof ChannelHandlerAdapter) {
//                ChannelHandlerAdapter handlerAdapter = (ChannelHandlerAdapter) channelHandler;
//                isSharable = handlerAdapter.isSharable();
//            }
//
//            // 判断是否是单例
//            if (!isSharable) {
//                channelHandler = ClassUtil.instance(channelHandler.getClass(), channelHandler.getConstructorArgs());
//            }
//
//            ch.pipeline().addLast(channelHandler.getGroup(), channelHandler.getName() + "-" + i, channelHandler);
    }

}