package cn.godmao.netty.server.base;

import cn.godmao.netty.codec.DefaultDecoder;
import cn.godmao.netty.handler.AbstractDecoderHandler;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.List;

@ChannelHandler.Sharable
public class ServerBaseDecoderHandler extends AbstractDecoderHandler<ByteBuf> {
//    private final Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf msg, List<Object> out) {
//        log.info("{} decode", ctx.channel().id());
        out.add(DefaultDecoder.me().decode(msg));
    }
}
