package cn.godmao.netty.client.base;

import cn.godmao.netty.codec.DefaultEncoder;
import cn.godmao.netty.handler.AbstractEncoderHandler;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.List;

@ChannelHandler.Sharable
public class ClientBaseEncoderHandler extends AbstractEncoderHandler<Object> {
//    private final Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    protected void encode(ChannelHandlerContext ctx, Object msg, List<Object> out) {
//        log.info("{} encode",ctx.channel().id());
        ByteBuf encode = DefaultEncoder.me().encode(msg);
        if (null == encode) {
            return;
        }
        out.add(encode);
    }
}

