package cn.godmao.netty;

import cn.godmao.netty.channel.DefaultChannelGroup;
import io.netty.channel.Channel;
import io.netty.util.AttributeKey;
import io.netty.util.AttributeMap;
import io.netty.util.NettyRuntime;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.ScheduledFuture;

import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;

public class ChannelService extends DefaultChannelGroup {
    public static final AttributeKey<EventExecutor> CHANNELEXECUTOR = AttributeKey.valueOf("channel-executor");
    public static final AttributeKey<String> CHANNELADDRESS  = AttributeKey.valueOf("channel-address");

    private final ExecutorService executorGroup;

    public ChannelService(String name, int threads) {
        super(name);
        this.executorGroup = new ExecutorService(threads, name());
    }

    public ChannelService(String name) {
        this(name, NettyRuntime.availableProcessors() * 2);
    }

    public ExecutorService getExecutorGroup() {
        return executorGroup;
    }


    public void bind(Channel channel, Object id) {
        boolean add = add(channel, id);
        final EventExecutor eventExecutor = executorGroup.select(id);
        channel.attr(CHANNELEXECUTOR).set(eventExecutor);
//        if (eventExecutor instanceof EventLoopGroup) {
//            EventLoopGroup eventExecutors = (EventLoopGroup) eventExecutor;
//            eventExecutors.register(channel);
//        }
    }

    private EventExecutor getChannelExecutor(AttributeMap attributeMap) {
        return attributeMap.attr(CHANNELEXECUTOR).get();
    }

    // ==========================================================================================
    public Future<?> submit(AttributeMap attributeMap, Runnable task) {
        return getChannelExecutor(attributeMap).submit(task);
    }

    public <T> Future<T> submit(AttributeMap attributeMap, Runnable task, T result) {
        return getChannelExecutor(attributeMap).submit(task, result);
    }

    public <T> Future<T> submit(AttributeMap attributeMap, Callable<T> task) {
        return getChannelExecutor(attributeMap).submit(task);
    }

    public ScheduledFuture<?> schedule(AttributeMap attributeMap, Runnable command, long delay, TimeUnit unit) {
        return getChannelExecutor(attributeMap).schedule(command, delay, unit);
    }

    public <V> ScheduledFuture<V> schedule(AttributeMap attributeMap, Callable<V> callable, long delay, TimeUnit unit) {
        return getChannelExecutor(attributeMap).schedule(callable, delay, unit);
    }
    // ==========================================================================================


}
