package cn.godmao.mate;

public enum MateUserState {
    ONLINE(-1, "匹配中/在线"),
    READY(1, "匹配中/准备"),
    OFFLINE(2, "匹配中/离线"),
    ;
    private final int state;
    private final String desc;

    MateUserState(int state, String desc) {
        this.state = state;
        this.desc = desc;
    }

    public int getState() {
        return state;
    }

    public String getDesc() {
        return desc;
    }

    public boolean equals(Integer state) {
        return state.equals(this.state);
    }


    public static MateUserState get(Integer state) {
        for (MateUserState eventEnum : MateUserState.values()) {
            if (eventEnum.equals(state)) return eventEnum;
        }
        return null;
    }
}
