package cn.godmao.match;

import java.util.Collection;

public interface IMatchService<R extends IMatchRoom> {

    /**
     * 比赛开始
     */
    default boolean start(R matchRoom) {
        final IMatchData data = matchRoom.getData();
        final IMatchRule rule = matchRoom.getRule();
        final Collection<? extends IMatchUser> users = matchRoom.getUsers();

        // 1 判断状态
        Integer state = data.getState();
        if (!MatchState.INMATCH.equals(state)) {
            return false;
        }

        // 2 判断人数是否小于分组人数
        if (rule.getGroupNum() > users.size()) {
            return false;
        }

        // 3 玩家过滤 过滤一些特殊玩家(例如:正在其他游戏中的玩家,或者不在线的玩家) fixme 在 satrt 之前判断过滤

        // 4 分组计算

        // 5 开始分组比赛

        return true;
    }
}
