package cn.godmao.match;

public enum MatchState {
    INWAIT(0, "等待中"),
    INREADY(1, "准备中"),
    INMATCH(2, "比赛中"),
    INEND(3, "结束"),
    ;
    private final int state;
    private final String desc;

    MatchState(int state, String desc) {
        this.state = state;
        this.desc = desc;
    }

    public int getState() {
        return state;
    }

    public String getDesc() {
        return desc;
    }

    public boolean equals(Integer state) {
        return state.equals(this.state);
    }
    
    public static MatchState get(Integer state) {
        for (MatchState eventEnum : values()) {
            if (eventEnum.equals(state)) return eventEnum;
        }
        return null;
    }
}
