//package cn.godmao.mahjong.service;
//
//import cn.godmao.mahjong.common.IPlayer;
//import cn.godmao.mahjong.common.IRoomData;
//import cn.godmao.mahjong.common.MahJong;
//
//public interface IRoomService<R extends IRoomData> {
//
//    // 开始游戏
//    void startGame(R roomData);
//
//    // 出牌
//    void outCard(R roomData, Integer seatIndex, Integer number);
//
//    // 摸牌
//    void pickCard(R roomData);
//
//    // 缺一门
//    void lack(R roomData, Integer seatIndex, Integer type);
//
//    // 副露
//    void fulu(R roomData, Integer seatIndex, Integer number, Integer state);
//
//    /**
//     * 检查是否没有任何状态
//     */
//    default boolean isNotFuluSate(IPlayer player) {
//        return null == player.getFulus() || player.getFulus().isEmpty();
//    }
//
//    /**
//     * 获取玩家最大副露状态
//     * 如果自动胡 最大状态就是胡
//     * 如果都没有 就是过
//     */
//    default Integer getMaxFuluState(IPlayer player) {
//        // 没有任何状态
//        if (isNotFuluSate(player)) {
//            return MahJong.FULU_DEFAULT;
//        }
//        // 先判断胡
//        if (player.getFulus().contains(MahJong.FULU_HU)) {
//            //
//            return MahJong.FULU_HU;
//        }
//        // 杠
//        if (player.getFulus().contains(MahJong.FULU_GANG)) {
//            return MahJong.FULU_GANG;
//        }
//        // 碰
//        if (player.getFulus().contains(MahJong.FULU_PENG)) {
//            return MahJong.FULU_PENG;
//        }
//        // 吃
//        if (player.getFulus().contains(MahJong.FULU_CHI)) {
//            return MahJong.FULU_CHI;
//        }
//        // 过
//        return MahJong.FULU_GUO;
//    }
//
//    /**
//     * 获取玩家自动触发最大副露状态
//     *
//     * @param player
//     * @return
//     */
//    default Integer getMaxAutoFuluState(IPlayer player) {
//        // 没有任何状态
//        if (isNotFuluSate(player)) {
//            return MahJong.FULU_DEFAULT;
//        }
//        // 先判断胡
//        if (player.getFuluAuto().contains(MahJong.FULU_HU) && player.getFulus().contains(MahJong.FULU_HU)) {
//            //
//            return MahJong.FULU_HU;
//        }
//        // 杠
//        if (player.getFuluAuto().contains(MahJong.FULU_GANG) && player.getFulus().contains(MahJong.FULU_GANG)) {
//            return MahJong.FULU_GANG;
//        }
//        // 碰
//        if (player.getFuluAuto().contains(MahJong.FULU_PENG) && player.getFulus().contains(MahJong.FULU_PENG)) {
//            return MahJong.FULU_PENG;
//        }
//        // 吃
//        if (player.getFuluAuto().contains(MahJong.FULU_CHI) && player.getFulus().contains(MahJong.FULU_CHI)) {
//            return MahJong.FULU_CHI;
//        }
//        // 过
//        return MahJong.FULU_GUO;
//    }
//}
