package cn.godmao.mahjong.common;

import cn.godmao.common.IBuilder;


public class MahJong implements IMahJong, Comparable<MahJong> {

//    // 副露
//    public static final int FULU_DEFAULT = -1;
//    public static final int FULU_GUO = 0;
//    public static final int FULU_HU = 1;
//    public static final int FULU_GANG = 2;
//    public static final int FULU_PENG = 3;
//    public static final int FULU_CHI = 4;
//    public static final int FULU_TING = 5;
//    public static final int FULU_TING_JIA = 6;


    // 类型
    public static final int TYPE_WAN = 1;
    public static final int TYPE_TONG = 2;
    public static final int TYPE_TIAO = 3;
    public static final int TYPE_FENG = 4;
    public static final int TYPE_JIAN = 5;
    public static final int TYPE_HUA = 6;

    // 万
    public static final int VALUE_WAN1 = 1;
    public static final int VALUE_WAN2 = 2;
    public static final int VALUE_WAN3 = 3;
    public static final int VALUE_WAN4 = 4;
    public static final int VALUE_WAN5 = 5;
    public static final int VALUE_WAN6 = 6;
    public static final int VALUE_WAN7 = 7;
    public static final int VALUE_WAN8 = 8;
    public static final int VALUE_WAN9 = 9;

    // 筒
    public static final int VALUE_TONG1 = 1;
    public static final int VALUE_TONG2 = 2;
    public static final int VALUE_TONG3 = 3;
    public static final int VALUE_TONG4 = 4;
    public static final int VALUE_TONG5 = 5;
    public static final int VALUE_TONG6 = 6;
    public static final int VALUE_TONG7 = 7;
    public static final int VALUE_TONG8 = 8;
    public static final int VALUE_TONG9 = 9;

    // 条
    public static final int VALUE_TIAO1 = 1;
    public static final int VALUE_TIAO2 = 2;
    public static final int VALUE_TIAO3 = 3;
    public static final int VALUE_TIAO4 = 4;
    public static final int VALUE_TIAO5 = 5;
    public static final int VALUE_TIAO6 = 6;
    public static final int VALUE_TIAO7 = 7;
    public static final int VALUE_TIAO8 = 8;
    public static final int VALUE_TIAO9 = 9;

    // 风
    public static final int VALUE_FENG_DONG = 1;
    public static final int VALUE_FENG_NAN = 2;
    public static final int VALUE_FENG_XI = 3;
    public static final int VALUE_FENG_BEI = 4;

    // 健
    public static final int VALUE_JIAN_ZHONG = 1;
    public static final int VALUE_JIAN_FA = 2;
    public static final int VALUE_JIAN_BAI = 3;

    // 花
    public static final int VALUE_HUA_CHUN = 1;
    public static final int VALUE_HUA_XIA = 2;
    public static final int VALUE_HUA_QIU = 3;
    public static final int VALUE_HUA_DONG = 4;
    public static final int VALUE_HUA_MEI = 5;
    public static final int VALUE_HUA_LAN = 6;
    public static final int VALUE_HUA_ZHU = 7;
    public static final int VALUE_HUA_JU = 8;

    // 牌型
    private Integer type;
    // 牌值
    private Integer value;
    // 牌唯一编号
    private Integer number;

    public MahJong(Integer type, Integer value, Integer number) {
        this.type = type;
        this.value = value;
        this.number = number;
    }

    @Override
    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    @Override
    public Integer getValue() {
        return value;
    }

    public void setValue(Integer value) {
        this.value = value;
    }

    @Override
    public Integer getNumber() {
        return number;
    }

    public void setNumber(Integer number) {
        this.number = number;
    }

    public MahJong() {
    }

    @Override
    public String toString() {
        String resultstr = "";

        if (type == TYPE_WAN) {
            resultstr = "万";
        } else if (type == TYPE_TONG) {
            resultstr = "筒";
        } else if (type == TYPE_TIAO) {
            resultstr = "条";
        }

        if ((type == TYPE_WAN || type == TYPE_TONG || type == TYPE_TIAO)) {
            if (value == VALUE_WAN1 || value == VALUE_TONG1 || value == VALUE_TIAO1) {
                resultstr = "一" + resultstr;
            } else if (value == VALUE_WAN2 || value == VALUE_TONG2 || value == VALUE_TIAO2) {
                resultstr = "二" + resultstr;
            } else if (value == VALUE_WAN3 || value == VALUE_TONG3 || value == VALUE_TIAO3) {
                resultstr = "三" + resultstr;
            } else if (value == VALUE_WAN4 || value == VALUE_TONG4 || value == VALUE_TIAO4) {
                resultstr = "四" + resultstr;
            } else if (value == VALUE_WAN5 || value == VALUE_TONG5 || value == VALUE_TIAO5) {
                resultstr = "五" + resultstr;
            } else if (value == VALUE_WAN6 || value == VALUE_TONG6 || value == VALUE_TIAO6) {
                resultstr = "六" + resultstr;
            } else if (value == VALUE_WAN7 || value == VALUE_TONG7 || value == VALUE_TIAO7) {
                resultstr = "七" + resultstr;
            } else if (value == VALUE_WAN8 || value == VALUE_TONG8 || value == VALUE_TIAO8) {
                resultstr = "八" + resultstr;
            } else if (value == VALUE_WAN9 || value == VALUE_TONG9 || value == VALUE_TIAO9) {
                resultstr = "九" + resultstr;
            }
        } else if (type == TYPE_FENG && value == VALUE_FENG_DONG) {
            resultstr = "东风" + resultstr;
        } else if (type == TYPE_FENG && value == VALUE_FENG_NAN) {
            resultstr = "南风" + resultstr;
        } else if (type == TYPE_FENG && value == VALUE_FENG_XI) {
            resultstr = "西风" + resultstr;
        } else if (type == TYPE_FENG && value == VALUE_FENG_BEI) {
            resultstr = "北风" + resultstr;
        } else if (type == TYPE_HUA && value == VALUE_HUA_MEI) {
            resultstr = "梅" + resultstr;
        } else if (type == TYPE_HUA && value == VALUE_HUA_LAN) {
            resultstr = "兰" + resultstr;
        } else if (type == TYPE_HUA && value == VALUE_HUA_ZHU) {
            resultstr = "竹" + resultstr;
        } else if (type == TYPE_HUA && value == VALUE_HUA_JU) {
            resultstr = "菊" + resultstr;
        } else if (type == TYPE_HUA && value == VALUE_HUA_CHUN) {
            resultstr = "春" + resultstr;
        } else if (type == TYPE_HUA && value == VALUE_HUA_XIA) {
            resultstr = "夏" + resultstr;
        } else if (type == TYPE_HUA && value == VALUE_HUA_QIU) {
            resultstr = "秋" + resultstr;
        } else if (type == TYPE_HUA && value == VALUE_HUA_DONG) {
            resultstr = "冬" + resultstr;
        } else if (type == TYPE_JIAN && value == VALUE_JIAN_ZHONG) {
            resultstr = "中";
        } else if (type == TYPE_JIAN && value == VALUE_JIAN_FA) {
            resultstr = "发";
        } else if (type == TYPE_JIAN && value == VALUE_JIAN_BAI) {
            resultstr = "白";
        }


        return resultstr;
    }

    @Override
    public int compareTo(MahJong o) {
        return !this.getType().equals(o.getType()) ? Integer.compare(this.getType(), o.getType()) :
                !this.getValue().equals(o.getValue()) ? Integer.compare(this.getValue(), o.getValue()) :
                        Integer.compare(this.getNumber(), o.getNumber());
    }

    public static class MahJongBuilder implements IBuilder<MahJong> {
        private Integer type;
        private Integer value;
        private Integer number;

        public MahJongBuilder type(Integer type) {
            this.type = type;
            return this;
        }

        public MahJongBuilder value(Integer value) {
            this.value = value;
            return this;
        }

        public MahJongBuilder number(Integer number) {
            this.number = number;
            return this;
        }

        public MahJongBuilder setType(Integer type) {
            this.type = type;
            return this;
        }

        public MahJongBuilder setValue(Integer value) {
            this.value = value;
            return this;
        }

        public MahJongBuilder setNumber(Integer number) {
            this.number = number;
            return this;
        }

        public MahJongBuilder() {

        }

        @Override
        public MahJong build() {
            return new MahJong(type, value, number);
        }
    }


    public static MahJongBuilder builder() {
        return new MahJongBuilder();
    }
}
