package cn.godmao.mahjong.common;

import java.util.Collection;
import java.util.Set;

/**
 * 游戏玩家
 */
public interface IPlayer {

    /**
     * 座位号
     */
    Integer getSeat();

    /**
     * 摸的牌
     */
    IMahJong getPick();

    /**
     * 定缺
     */
    Integer getLack();

    /**
     * 积分
     */
    Long getScore();

    /**
     * 手牌
     */
    IHandCard getHandCard();

    /**
     * 自动副露执行
     */
    Set<Integer> getFuluAuto();

    /**
     * 当前副露状态
     */
    Integer getFuluState();

    /**
     * 获取当前副露效果
     */
    Set<Integer> getFulus();

    /**
     * 副露牌
     */
    Collection<? extends IFuluCard> getFuluCards();

}
