/*
 * Decompiled with CFR 0.152.
 */
package cn.godmao.mahjong.common;

import cn.godmao.common.IBuilder;
import cn.godmao.mahjong.common.IMahJong;

public class MahJong
implements IMahJong,
Comparable<MahJong> {
    public static final int FULU_DEFAULT = -1;
    public static final int FULU_GUO = 0;
    public static final int FULU_HU = 1;
    public static final int FULU_GANG = 2;
    public static final int FULU_PENG = 3;
    public static final int FULU_CHI = 4;
    public static final int FULU_TING = 5;
    public static final int FULU_TING_JIA = 6;
    public static final int TYPE_WAN = 1;
    public static final int TYPE_TONG = 2;
    public static final int TYPE_TIAO = 3;
    public static final int TYPE_FENG = 4;
    public static final int TYPE_JIAN = 5;
    public static final int TYPE_HUA = 6;
    public static final int VALUE_WAN1 = 1;
    public static final int VALUE_WAN2 = 2;
    public static final int VALUE_WAN3 = 3;
    public static final int VALUE_WAN4 = 4;
    public static final int VALUE_WAN5 = 5;
    public static final int VALUE_WAN6 = 6;
    public static final int VALUE_WAN7 = 7;
    public static final int VALUE_WAN8 = 8;
    public static final int VALUE_WAN9 = 9;
    public static final int VALUE_TONG1 = 1;
    public static final int VALUE_TONG2 = 2;
    public static final int VALUE_TONG3 = 3;
    public static final int VALUE_TONG4 = 4;
    public static final int VALUE_TONG5 = 5;
    public static final int VALUE_TONG6 = 6;
    public static final int VALUE_TONG7 = 7;
    public static final int VALUE_TONG8 = 8;
    public static final int VALUE_TONG9 = 9;
    public static final int VALUE_TIAO1 = 1;
    public static final int VALUE_TIAO2 = 2;
    public static final int VALUE_TIAO3 = 3;
    public static final int VALUE_TIAO4 = 4;
    public static final int VALUE_TIAO5 = 5;
    public static final int VALUE_TIAO6 = 6;
    public static final int VALUE_TIAO7 = 7;
    public static final int VALUE_TIAO8 = 8;
    public static final int VALUE_TIAO9 = 9;
    public static final int VALUE_FENG_DONG = 1;
    public static final int VALUE_FENG_NAN = 2;
    public static final int VALUE_FENG_XI = 3;
    public static final int VALUE_FENG_BEI = 4;
    public static final int VALUE_JIAN_ZHONG = 1;
    public static final int VALUE_JIAN_FA = 2;
    public static final int VALUE_JIAN_BAI = 3;
    public static final int VALUE_HUA_CHUN = 1;
    public static final int VALUE_HUA_XIA = 2;
    public static final int VALUE_HUA_QIU = 3;
    public static final int VALUE_HUA_DONG = 4;
    public static final int VALUE_HUA_MEI = 5;
    public static final int VALUE_HUA_LAN = 6;
    public static final int VALUE_HUA_ZHU = 7;
    public static final int VALUE_HUA_JU = 8;
    private Integer type;
    private Integer value;
    private Integer number;

    public MahJong(Integer type, Integer value, Integer number) {
        this.type = type;
        this.value = value;
        this.number = number;
    }

    @Override
    public Integer getType() {
        return this.type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    @Override
    public Integer getValue() {
        return this.value;
    }

    public void setValue(Integer value) {
        this.value = value;
    }

    @Override
    public Integer getNumber() {
        return this.number;
    }

    public void setNumber(Integer number) {
        this.number = number;
    }

    public MahJong() {
    }

    public String toString() {
        String resultstr = "";
        if (this.type == 1) {
            resultstr = "\u4e07";
        } else if (this.type == 2) {
            resultstr = "\u7b52";
        } else if (this.type == 3) {
            resultstr = "\u6761";
        }
        if (this.type == 1 || this.type == 2 || this.type == 3) {
            if (this.value == 1 || this.value == 1 || this.value == 1) {
                resultstr = "\u4e00" + resultstr;
            } else if (this.value == 2 || this.value == 2 || this.value == 2) {
                resultstr = "\u4e8c" + resultstr;
            } else if (this.value == 3 || this.value == 3 || this.value == 3) {
                resultstr = "\u4e09" + resultstr;
            } else if (this.value == 4 || this.value == 4 || this.value == 4) {
                resultstr = "\u56db" + resultstr;
            } else if (this.value == 5 || this.value == 5 || this.value == 5) {
                resultstr = "\u4e94" + resultstr;
            } else if (this.value == 6 || this.value == 6 || this.value == 6) {
                resultstr = "\u516d" + resultstr;
            } else if (this.value == 7 || this.value == 7 || this.value == 7) {
                resultstr = "\u4e03" + resultstr;
            } else if (this.value == 8 || this.value == 8 || this.value == 8) {
                resultstr = "\u516b" + resultstr;
            } else if (this.value == 9 || this.value == 9 || this.value == 9) {
                resultstr = "\u4e5d" + resultstr;
            }
        } else if (this.type == 4 && this.value == 1) {
            resultstr = "\u4e1c\u98ce" + resultstr;
        } else if (this.type == 4 && this.value == 2) {
            resultstr = "\u5357\u98ce" + resultstr;
        } else if (this.type == 4 && this.value == 3) {
            resultstr = "\u897f\u98ce" + resultstr;
        } else if (this.type == 4 && this.value == 4) {
            resultstr = "\u5317\u98ce" + resultstr;
        } else if (this.type == 6 && this.value == 5) {
            resultstr = "\u6885" + resultstr;
        } else if (this.type == 6 && this.value == 6) {
            resultstr = "\u5170" + resultstr;
        } else if (this.type == 6 && this.value == 7) {
            resultstr = "\u7af9" + resultstr;
        } else if (this.type == 6 && this.value == 8) {
            resultstr = "\u83ca" + resultstr;
        } else if (this.type == 6 && this.value == 1) {
            resultstr = "\u6625" + resultstr;
        } else if (this.type == 6 && this.value == 2) {
            resultstr = "\u590f" + resultstr;
        } else if (this.type == 6 && this.value == 3) {
            resultstr = "\u79cb" + resultstr;
        } else if (this.type == 6 && this.value == 4) {
            resultstr = "\u51ac" + resultstr;
        } else if (this.type == 5 && this.value == 1) {
            resultstr = "\u4e2d";
        } else if (this.type == 5 && this.value == 2) {
            resultstr = "\u53d1";
        } else if (this.type == 5 && this.value == 3) {
            resultstr = "\u767d";
        }
        return resultstr;
    }

    @Override
    public int compareTo(MahJong o) {
        return this.getType().equals(o.getType()) ? this.getValue() - o.getValue() : this.getType() - o.getType();
    }

    public static MahJongBuilder builder() {
        return new MahJongBuilder();
    }

    public static class MahJongBuilder
    implements IBuilder<MahJong> {
        private Integer type;
        private Integer value;
        private Integer number;

        public MahJongBuilder type(Integer type) {
            this.type = type;
            return this;
        }

        public MahJongBuilder value(Integer value) {
            this.value = value;
            return this;
        }

        public MahJongBuilder number(Integer number) {
            this.number = number;
            return this;
        }

        public MahJongBuilder setType(Integer type) {
            this.type = type;
            return this;
        }

        public MahJongBuilder setValue(Integer value) {
            this.value = value;
            return this;
        }

        public MahJongBuilder setNumber(Integer number) {
            this.number = number;
            return this;
        }

        public MahJong build() {
            return new MahJong(this.type, this.value, this.number);
        }
    }
}

