/*
 * Decompiled with CFR 0.152.
 */
package cn.godmao.lock.aspect;

import cn.godmao.aspectj.AspectExpress;
import cn.godmao.lock.service.LockService;
import java.util.concurrent.locks.Lock;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;

@Aspect
public class LockAspect {
    private final LockService<Lock> lockService;

    public LockAspect(LockService<Lock> lockService) {
        this.lockService = lockService;
    }

    @Pointcut(value="execution(* *(..)) && @annotation(alock)")
    public void pointCut(cn.godmao.lock.annotation.Lock alock) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="pointCut(alock)", argNames="point,alock")
    public Object around(ProceedingJoinPoint point, cn.godmao.lock.annotation.Lock alock) throws Throwable {
        String[] keys = AspectExpress.setKeys((ProceedingJoinPoint)point, (String[])alock.value());
        Lock lock = keys.length == 0 ? this.lockService.getLock(point.getSignature().getDeclaringTypeName() + "." + point.getSignature().getName()) : this.lockService.getLock(keys);
        try {
            this.lockService.lock(lock);
            Object object = point.proceed();
            return object;
        }
        finally {
            this.lockService.unlock(lock);
        }
    }
}

