package cn.godmao.lock.aspect;

import cn.godmao.aspectj.AspectExpress;
import cn.godmao.lock.annotation.Lock;
import cn.godmao.lock.service.LockService;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;

@Aspect
public class LockAspect {
    private final LockService<java.util.concurrent.locks.Lock> lockService;

    public LockAspect(LockService<java.util.concurrent.locks.Lock> lockService) {
        this.lockService = lockService;
    }

    @Pointcut("execution(* *(..)) && @annotation(alock)")
    public void pointCut(Lock alock) {
    }

    @Around(value = "pointCut(alock)", argNames = "point,alock")
    public Object around(ProceedingJoinPoint point, Lock alock) throws Throwable {
        final java.util.concurrent.locks.Lock lock;
        String[] keys = AspectExpress.setKeys(point, alock.value());
        if (keys.length == 0) {
            lock = lockService.getLock(point.getSignature().getDeclaringTypeName() + "." + point.getSignature().getName());
        } else {
            lock = lockService.getLock(keys);
        }


//        // fixme 打印
//        for (String key : keys) {
//            System.err.println("lock ========= " + key);
//        }

        try {
            lockService.lock(lock);
            return point.proceed();
        } finally {
            lockService.unlock(lock);
        }
    }
}