/*
 * Decompiled with CFR 0.152.
 */
package cn.godmao.lock.aspect;

import cn.godmao.aspectj.AspectExpress;
import cn.godmao.aspectj.IAspect;
import cn.godmao.lock.annotation.Lock;
import cn.godmao.lock.service.LockService;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;

@Aspect
public class LockAspect
implements IAspect<Lock> {
    private final LockService<java.util.concurrent.locks.Lock> lockService;

    public LockAspect(LockService<java.util.concurrent.locks.Lock> lockService) {
        this.lockService = lockService;
    }

    @Pointcut(value="execution(* *(..)) && @annotation(alock)")
    public void pointCut(Lock alock) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="pointCut(alock)", argNames="point,alock")
    public Object around(ProceedingJoinPoint point, Lock alock) throws Throwable {
        String[] keys = AspectExpress.setKeys((ProceedingJoinPoint)point, (String[])alock.value());
        java.util.concurrent.locks.Lock lock = keys.length == 0 ? this.lockService.getLock(point.getSignature().getDeclaringTypeName() + "." + point.getSignature().getName()) : this.lockService.getLock(keys);
        try {
            this.lockService.lock(lock);
            Object object = point.proceed();
            return object;
        }
        finally {
            this.lockService.unlock(lock);
        }
    }
}

