/*
 * Decompiled with CFR 0.152.
 */
package cn.godmao.lock.service;

import cn.godmao.lock.service.ILockService;
import cn.godmao.lock.template.LockTemplate;
import cn.godmao.lock.template.ReentrantLockTemplate;
import java.util.concurrent.Future;
import java.util.concurrent.locks.Lock;
import org.springframework.beans.factory.annotation.Autowired;

public class LockService<L extends Lock>
implements ILockService<L> {
    private static final String LOCK = "LOCK_";
    @Autowired(required=false)
    public LockTemplate<L> lockTemplate = ReentrantLockTemplate.me();

    public LockTemplate<L> getLockTemplate() {
        return this.lockTemplate;
    }

    private L get(String key) {
        return this.getLockTemplate().get(this.getLockKey(key));
    }

    private L get(String ... keys) {
        return this.getLockTemplate().get(this.getLockKey(keys));
    }

    @Override
    public L getLock(String ... key) {
        this.check(key);
        return key.length == 1 ? this.get(key[0]) : this.get(key);
    }

    @Override
    public void lock(L lock) {
        this.getLockTemplate().lock(lock);
    }

    @Override
    public boolean tryLock(L lock) {
        return this.getLockTemplate().tryLock(lock);
    }

    @Override
    public boolean tryLock(L lock, long waitTime) throws Exception {
        return this.getLockTemplate().tryLock(lock, waitTime);
    }

    @Override
    public boolean tryLock(L lock, long waitTime, long leaseTime) throws Exception {
        return this.getLockTemplate().tryLock(lock, waitTime, leaseTime);
    }

    @Override
    public void unlock(L lock) {
        this.getLockTemplate().unlock(lock);
    }

    @Override
    public void execute(Runnable runnable, String ... key) throws Exception {
        this.getLockTemplate().execute(runnable, this.getLock(key));
    }

    @Override
    public void execute(Runnable runnable, long waitTime, String ... key) throws Exception {
        this.getLockTemplate().execute(runnable, waitTime, this.getLock(key));
    }

    @Override
    public void execute(Runnable runnable, long waitTime, long leaseTime, String ... key) throws Exception {
        this.getLockTemplate().execute(runnable, waitTime, leaseTime, this.getLock(key));
    }

    @Override
    public <R> R execute(Runnable runnable, R result, String ... key) throws Exception {
        return this.getLockTemplate().execute(runnable, result, this.getLock(key));
    }

    @Override
    public <R> R execute(Runnable runnable, R result, long waitTime, String ... key) throws Exception {
        return this.getLockTemplate().execute(runnable, result, waitTime, this.getLock(key));
    }

    @Override
    public <R> R execute(Runnable runnable, R result, long waitTime, long leaseTime, String ... key) throws Exception {
        return this.getLockTemplate().execute(runnable, result, waitTime, leaseTime, this.getLock(key));
    }

    @Override
    public <T> Future<T> submit(Runnable runnable, T result, String ... key) throws Exception {
        return this.lockTemplate.submit(runnable, result, this.getLock(key));
    }

    @Override
    public <T> Future<T> submit(Runnable runnable, T result, long waitTime, String ... key) throws Exception {
        return this.lockTemplate.submit(runnable, result, waitTime, this.getLock(key));
    }

    @Override
    public <T> Future<T> submit(Runnable runnable, T result, long waitTime, long leaseTime, String ... key) throws Exception {
        return this.lockTemplate.submit(runnable, result, waitTime, leaseTime, this.getLock(key));
    }

    private void check(String ... key) {
        if (null == key || key.length == 0) {
            throw new NullPointerException(this.getClass().getSimpleName() + " Exception: key Cannot be empty!");
        }
    }

    private String getLockKey(String key) {
        return LOCK + key;
    }

    private String[] getLockKey(String ... key) {
        String[] lockKeys = new String[key.length];
        for (int i = 0; i < key.length; ++i) {
            lockKeys[i] = this.getLockKey(key[i]);
        }
        return lockKeys;
    }
}

