package cn.godmao.lock.service;

import cn.godmao.lock.template.LockTemplate;
import cn.godmao.lock.template.ReentrantLockTemplate;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.concurrent.Future;
import java.util.concurrent.locks.Lock;


public class LockService<L extends Lock> implements ILockService<L> {
    private static final String LOCK = "LOCK_";

    @Autowired(required = false)
    @SuppressWarnings("unchecked")
    public LockTemplate<L> lockTemplate = (LockTemplate<L>) ReentrantLockTemplate.me();


    public LockTemplate<L> getLockTemplate() {
        return lockTemplate;
    }

    private L get(String key) {
        return getLockTemplate().get(getLockKey(key));
    }

    private L get(String... keys) {
        return getLockTemplate().get(getLockKey(keys));
    }

    @Override
    public L getLock(String... key) {
        check(key);
        return key.length == 1 ? get(key[0]) : get(key);
    }

    @Override
    public void lock(L lock) {
        getLockTemplate().lock(lock);
    }

    @Override
    public boolean tryLock(L lock) {
        return getLockTemplate().tryLock(lock);
    }

    @Override
    public boolean tryLock(L lock, long waitTime) throws Exception {
        return getLockTemplate().tryLock(lock, waitTime);
    }

    @Override
    public boolean tryLock(L lock, long waitTime, long leaseTime) throws Exception {
        return getLockTemplate().tryLock(lock, waitTime, leaseTime);
    }

    @Override
    public void unlock(L lock) {
        getLockTemplate().unlock(lock);
    }

    @Override
    public void execute(Runnable runnable, String... key) throws Exception {
        getLockTemplate().execute(runnable, getLock(key));
    }

    @Override
    public void execute(Runnable runnable, long waitTime, String... key) throws Exception {
        getLockTemplate().execute(runnable, waitTime, getLock(key));
    }

    @Override
    public void execute(Runnable runnable, long waitTime, long leaseTime, String... key) throws Exception {
        getLockTemplate().execute(runnable, waitTime, leaseTime, getLock(key));
    }

    @Override
    public <R> R execute(Runnable runnable, R result, String... key) throws Exception {
        return getLockTemplate().execute(runnable, result, getLock(key));
    }

    @Override
    public <R> R execute(Runnable runnable, R result, long waitTime, String... key) throws Exception {
        return getLockTemplate().execute(runnable, result, waitTime, getLock(key));
    }

    @Override
    public <R> R execute(Runnable runnable, R result, long waitTime, long leaseTime, String... key) throws Exception {
        return getLockTemplate().execute(runnable, result, waitTime, leaseTime, getLock(key));
    }

    @Override
    public <T> Future<T> submit(Runnable runnable, T result, String... key) throws Exception {
        return lockTemplate.submit(runnable, result, getLock(key));
    }

    @Override
    public <T> Future<T> submit(Runnable runnable, T result, long waitTime, String... key) throws Exception {
        return lockTemplate.submit(runnable, result, waitTime, getLock(key));
    }

    @Override
    public <T> Future<T> submit(Runnable runnable, T result, long waitTime, long leaseTime, String... key) throws Exception {
        return lockTemplate.submit(runnable, result, waitTime, leaseTime, getLock(key));
    }

    private void check(String... key) {
        if (null == key || key.length == 0) {
            throw new NullPointerException(this.getClass().getSimpleName() + " Exception: key Cannot be empty!");
        }
    }

    private String getLockKey(String key) {
        return LOCK + key;
    }

    private String[] getLockKey(String... key) {
        String[] lockKeys = new String[key.length];
        for (int i = 0; i < key.length; i++) {
            lockKeys[i] = getLockKey(key[i]);
        }
        return lockKeys;
    }

//    private LockService() {
//
//    }
//
//    public static LockService<? extends Lock> me() {
//        return Holder.ME;
//    }
//
//    private static class Holder {
//        static final LockService<? extends Lock> ME = new LockService<>();
//    }
}
