/*
 * Decompiled with CFR 0.152.
 */
package cn.godmao.lock.template;

import cn.godmao.lock.template.LockTemplate;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;

public class ReentrantLockTemplate
implements LockTemplate<ReentrantLock> {
    private Map<String, ReentrantLock> lockMap = new HashMap<String, ReentrantLock>();

    @Override
    public synchronized ReentrantLock get(String key) {
        ReentrantLock lock = this.lockMap.get(key);
        if (null == lock) {
            lock = new ReentrantLock(true);
            this.lockMap.put(key, lock);
        }
        return lock;
    }

    @Override
    public ReentrantLock get(String ... key) {
        throw new IllegalArgumentException(this.getClass().getSimpleName() + " Exception " + Thread.currentThread().getStackTrace()[1].getMethodName() + " not implemented");
    }

    @Override
    public void lock(ReentrantLock lock) {
        lock.lock();
    }

    @Override
    public boolean tryLock(ReentrantLock lock) {
        return lock.tryLock();
    }

    @Override
    public boolean tryLock(ReentrantLock lock, long waitTime) throws InterruptedException {
        return lock.tryLock(waitTime, TimeUnit.MILLISECONDS);
    }

    @Override
    public boolean tryLock(ReentrantLock lock, long waitTime, long leaseTime) {
        throw new IllegalArgumentException(this.getClass().getSimpleName() + " Exception " + Thread.currentThread().getStackTrace()[1].getMethodName() + " not implemented");
    }

    @Override
    public void unlock(ReentrantLock lock) {
        if (lock.isLocked() && lock.isHeldByCurrentThread()) {
            lock.unlock();
        }
    }

    @Override
    public synchronized boolean remove(String key) {
        this.lockMap.remove(key);
        return true;
    }

    @Override
    public long remove(String ... key) {
        throw new IllegalArgumentException(this.getClass().getSimpleName() + " Exception " + Thread.currentThread().getStackTrace()[1].getMethodName() + " not implemented");
    }

    @Override
    public void execute(Runnable runnable, ReentrantLock lock) {
        try {
            this.lock(lock);
            runnable.run();
        }
        finally {
            this.unlock(lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(Runnable runnable, long waitTime, ReentrantLock lock) throws Exception {
        boolean tryLock = this.tryLock(lock, waitTime);
        if (tryLock) {
            try {
                runnable.run();
            }
            finally {
                this.unlock(lock);
            }
        }
    }

    @Override
    public void execute(Runnable runnable, long waitTime, long leaseTime, ReentrantLock lock) throws Exception {
        throw new IllegalArgumentException(this.getClass().getSimpleName() + " Exception " + Thread.currentThread().getStackTrace()[1].getMethodName() + " not implemented");
    }

    @Override
    public <R> R execute(Runnable runnable, R result, ReentrantLock lock) throws Exception {
        throw new IllegalArgumentException(this.getClass().getSimpleName() + " Exception " + Thread.currentThread().getStackTrace()[1].getMethodName() + " not implemented");
    }

    @Override
    public <R> R execute(Runnable runnable, R result, long waitTime, ReentrantLock lock) throws Exception {
        throw new IllegalArgumentException(this.getClass().getSimpleName() + " Exception " + Thread.currentThread().getStackTrace()[1].getMethodName() + " not implemented");
    }

    @Override
    public <R> R execute(Runnable runnable, R result, long waitTime, long leaseTime, ReentrantLock lock) throws Exception {
        throw new IllegalArgumentException(this.getClass().getSimpleName() + " Exception " + Thread.currentThread().getStackTrace()[1].getMethodName() + " not implemented");
    }

    @Override
    public <T> Future<T> submit(Runnable runnable, T result, ReentrantLock lock) {
        throw new IllegalArgumentException(this.getClass().getSimpleName() + " Exception " + Thread.currentThread().getStackTrace()[1].getMethodName() + " not implemented");
    }

    @Override
    public <T> Future<T> submit(Runnable runnable, T result, long waitTime, ReentrantLock lock) throws Exception {
        throw new IllegalArgumentException(this.getClass().getSimpleName() + " Exception " + Thread.currentThread().getStackTrace()[1].getMethodName() + " not implemented");
    }

    @Override
    public <T> Future<T> submit(Runnable runnable, T result, long waitTime, long leaseTime, ReentrantLock lock) throws Exception {
        throw new IllegalArgumentException(this.getClass().getSimpleName() + " Exception " + Thread.currentThread().getStackTrace()[1].getMethodName() + " not implemented");
    }

    private ReentrantLockTemplate() {
    }

    public static ReentrantLockTemplate me() {
        return Holder.ME;
    }

    private static class Holder {
        static final ReentrantLockTemplate ME = new ReentrantLockTemplate();

        private Holder() {
        }
    }
}

