package cn.godmao.lock.template;
import java.util.concurrent.Future;
import java.util.concurrent.locks.Lock;
public interface LockTemplate<L extends Lock> {
    L get(String key);

    L get(String... key);

    void lock(L lock);

    boolean tryLock(L lock);

    boolean tryLock(L lock, long waitTime) throws Exception;

    boolean tryLock(L lock, long waitTime, long leaseTime) throws Exception;

    void unlock(L lock);

    boolean remove(String key);

    long remove(String... key);


    void execute(Runnable runnable, L lock) throws Exception;

    void execute(Runnable runnable, long waitTime, L lock) throws Exception;

    void execute(Runnable runnable, long waitTime, long leaseTime, L lock) throws Exception;

    <R> R execute(Runnable runnable, R result, L lock) throws Exception;

    <R> R execute(Runnable runnable, R result, long waitTime, L lock) throws Exception;

    <R> R execute(Runnable runnable, R result, long waitTime, long leaseTime, L lock) throws Exception;

    <T> Future<T> submit(Runnable runnable, T result, L lock) throws Exception;

    <T> Future<T> submit(Runnable runnable, T result, long waitTime, L lock) throws Exception;

    <T> Future<T> submit(Runnable runnable, T result, long waitTime, long leaseTime, L lock) throws Exception;
}
