/*
 * Decompiled with CFR 0.152.
 */
package cn.godmao.lock.aspect;

import cn.godmao.aspectj.AspectExpress;
import cn.godmao.lock.annotation.Lock;
import cn.godmao.lock.service.LockService;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;

@Aspect
public class LockAspect {
    private LockService<java.util.concurrent.locks.Lock> lockService;
    private boolean init = false;

    public synchronized void init(LockService<java.util.concurrent.locks.Lock> lockService) {
        if (!this.init) {
            this.lockService = lockService;
            this.init = true;
        }
    }

    @Pointcut(value="execution(* *(..)) && @annotation(alock)")
    public void pointCut(Lock alock) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="pointCut(alock)", argNames="point,alock")
    public Object around(ProceedingJoinPoint point, Lock alock) throws Throwable {
        String[] keys = AspectExpress.setKeys((ProceedingJoinPoint)point, (String[])alock.value());
        java.util.concurrent.locks.Lock lock = keys.length == 0 ? this.lockService.getLock(point.getSignature().getDeclaringTypeName() + "." + point.getSignature().getName()) : this.lockService.getLock(keys);
        if (alock.log()) {
            for (String key : keys) {
                System.err.println("lock ========= " + key);
            }
        }
        try {
            this.lockService.lock(lock);
            Object object = point.proceed();
            return object;
        }
        finally {
            this.lockService.unlock(lock);
        }
    }

    public static LockAspect me() {
        return Holder.ME;
    }

    private static class Holder {
        static final LockAspect ME = new LockAspect();

        private Holder() {
        }
    }
}

