package cn.godmao.lock.service;

import java.util.concurrent.Future;
import java.util.concurrent.locks.Lock;

public interface ILockService<L extends Lock> {
    L getLock(String... key);

    void lock(L lock);

    boolean tryLock(L lock);

    boolean tryLock(L lock, long waitTime) throws Exception;

    boolean tryLock(L lock, long waitTime, long leaseTime) throws Exception;

    void unlock(L lock);

    void execute(Runnable runnable, String... key) throws Exception;

    void execute(Runnable runnable, long waitTime, String... key) throws Exception;

    void execute(Runnable runnable, long waitTime, long leaseTime, String... key) throws Exception;

    <R> R execute(Runnable runnable, R result, String... key) throws Exception;

    <R> R execute(Runnable runnable, R result, long waitTime, String... key) throws Exception;

    <R> R execute(Runnable runnable, R result, long waitTime, long leaseTime, String... key) throws Exception;


    <T> Future<T> submit(Runnable runnable, T result, String... key) throws Exception;

    <T> Future<T> submit(Runnable runnable, T result, long waitTime, String... key) throws Exception;

    <T> Future<T> submit(Runnable runnable, T result, long waitTime, long leaseTime, String... key) throws Exception;
}
