package cn.godmao.json;

import com.alibaba.fastjson2.JSONFactory;
import com.alibaba.fastjson2.reader.ObjectReaderProvider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class JsonUtil {
    static final ObjectReaderProvider provider = JSONFactory.getDefaultObjectReaderProvider();

    public static <T extends Json, R> List<R> getArr(Collection<T> collection, Class<R> clazz) {
        List<R> result = new ArrayList<>(collection.size());
        for (T t : collection) {
            result.add(t.toJava(clazz));
        }
        return result;
    }

    @SuppressWarnings("unchecked")
    public static <T> T parse(Object object, Class<T> clazz) {
        return (T) provider.getTypeConvert(object.getClass(), clazz).apply(object);
    }

}
