package cn.godmao.json;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;

import java.io.Serializable;

public interface Json extends Serializable {
    default String toJSONString(SerializerFeature... features) {
        return JSON.toJSONString(this, features);
    }

    default <T> T toJava(Class<T> clazz, SerializerFeature... features) {
        return JSON.parseObject(toJSONString(features), clazz);
    }
    
    default JSONObject toJSONObject(SerializerFeature... features) {
        return JSON.parseObject(toJSONString(features));
    }
}
