/*
 * Decompiled with CFR 0.152.
 */
package cn.godmao.getty.server.base;

import cn.godmao.common.Init;
import cn.godmao.getty.codec.IDecoder;
import cn.godmao.getty.server.ServerConfig;
import cn.godmao.utils.CollectUtil;
import cn.godmao.utils.ProtostuffUtil;
import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.DecoderException;
import java.util.Map;

public class ServerBaseDecoder
implements IDecoder<ByteBuf, Object>,
Init.Init1<ServerConfig> {
    Map<String, ? extends Class<?>> classMap;

    public void init(ServerConfig config) {
        this.classMap = CollectUtil.toMap(config.getMessageClass(), Class::getSimpleName);
    }

    @Override
    public Object decode(ByteBuf byteBuf) throws DecoderException, ClassNotFoundException {
        int writerIndex;
        if (!byteBuf.isReadable()) {
            return byteBuf;
        }
        int messageSize = byteBuf.readInt();
        if (messageSize != (writerIndex = byteBuf.writerIndex())) {
            return byteBuf;
        }
        int messageSize_type = byteBuf.readInt();
        byte[] data_message_type = new byte[messageSize_type];
        byteBuf.readBytes(data_message_type);
        String message_type = new String(data_message_type);
        Class<?> clazz = this.classMap.get(message_type);
        if (null == clazz) {
            clazz = Class.forName(message_type);
        }
        byte[] data_message = new byte[byteBuf.readableBytes()];
        byteBuf.readBytes(data_message);
        return ProtostuffUtil.deserialize((byte[])data_message, clazz);
    }
}

