/*
 * Decompiled with CFR 0.152.
 */
package cn.godmao.getty.client.base;

import cn.godmao.common.Init;
import cn.godmao.getty.InitBaseChannel;
import cn.godmao.getty.client.AbstractClient;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.websocketx.WebSocketClientProtocolConfig;
import io.netty.handler.codec.http.websocketx.WebSocketClientProtocolHandler;
import io.netty.handler.codec.http.websocketx.extensions.compression.WebSocketClientCompressionHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import io.netty.handler.stream.ChunkedWriteHandler;

public class WebsocketClientBaseInitializer
extends ChannelInitializer<Channel>
implements Init.Init1<AbstractClient> {
    private AbstractClient server;

    public void init(AbstractClient server) {
        this.server = server;
    }

    protected void initChannel(Channel ch) throws Exception {
        ChannelPipeline pipeline = ch.pipeline();
        if (this.server.getUri().getPort() == 443) {
            SslContext sslCtx = SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).build();
            pipeline.addLast(new ChannelHandler[]{sslCtx.newHandler(ch.alloc(), this.server.getUri().getHost(), this.server.getUri().getPort())});
        }
        pipeline.addLast(new ChannelHandler[]{new HttpClientCodec()});
        pipeline.addLast(new ChannelHandler[]{new HttpObjectAggregator(65536)});
        pipeline.addLast(new ChannelHandler[]{new ChunkedWriteHandler()});
        pipeline.addLast(new ChannelHandler[]{WebSocketClientCompressionHandler.INSTANCE});
        pipeline.addLast(new ChannelHandler[]{new WebSocketClientProtocolHandler(WebSocketClientProtocolConfig.newBuilder().webSocketUri(this.server.getUri()).allowExtensions(true).maxFramePayloadLength(Integer.MAX_VALUE).build())});
        InitBaseChannel.initChannel(pipeline, this.server);
    }
}

