/*
 * Decompiled with CFR 0.152.
 */
package cn.godmao.getty;

import cn.godmao.common.IRunnable;
import cn.godmao.common.ISchedule;
import cn.godmao.executor.AbstractExecutorService;
import io.netty.util.NettyRuntime;
import io.netty.util.concurrent.DefaultEventExecutor;
import io.netty.util.concurrent.DefaultThreadFactory;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;

public class ExecutorService
extends AbstractExecutorService<EventExecutor>
implements ISchedule {
    public ExecutorService(int threads, ThreadFactory threadFactory) {
        super((java.util.concurrent.ExecutorService[])new EventExecutor[threads]);
        this.setThreadFactory(threadFactory);
    }

    public ExecutorService() {
        this(NettyRuntime.availableProcessors(), null);
    }

    public ExecutorService(int threads) {
        this(threads, null);
    }

    private void setThreadFactory(ThreadFactory threadFactory) {
        ThreadFactory factory = null == threadFactory ? new DefaultThreadFactory(((Object)((Object)this)).getClass(), false) : threadFactory;
        for (int i = 0; i < ((EventExecutor[])this.getExecutors()).length; ++i) {
            ((EventExecutor[])this.getExecutors())[i] = new DefaultEventExecutor(factory);
        }
    }

    public ScheduledFuture<?> schedule(Object key, IRunnable runnable, long delay) {
        return this.schedule((ScheduledExecutorService)this.select(key), runnable, delay);
    }

    public ScheduledFuture<?> schedule(Object key, IRunnable runnable, long delay, long period) {
        return this.schedule((ScheduledExecutorService)this.select(key), runnable, delay, period);
    }

    public ScheduledFuture<?> schedule(IRunnable runnable, long delay) {
        return this.schedule((ScheduledExecutorService)this.next(), runnable, delay);
    }

    public ScheduledFuture<?> schedule(IRunnable runnable, long delay, long period) {
        return this.schedule((ScheduledExecutorService)this.next(), runnable, delay, period);
    }

    public Future<?> submit(Object key, IRunnable task) {
        return this.submit((EventExecutor)this.select(key), task);
    }

    public <T> Future<T> submit(Object key, IRunnable task, T result) {
        return this.submit((EventExecutor)this.select(key), task, result);
    }

    public <T> Future<T> submit(Object key, Callable<T> task) {
        return this.submit((EventExecutor)this.select(key), task);
    }

    public Future<?> submit(EventExecutor executor, IRunnable task) {
        return executor.submit((Runnable)task);
    }

    public <T> Future<T> submit(EventExecutor executor, IRunnable task, T result) {
        return executor.submit((Runnable)task, result);
    }

    public <T> Future<T> submit(EventExecutor executor, Callable<T> task) {
        return executor.submit(task);
    }

    public Future<?> submit(IRunnable task) {
        return this.submit((EventExecutor)this.next(), task);
    }

    public <T> Future<T> submit(IRunnable task, T result) {
        return this.submit((EventExecutor)this.next(), task, result);
    }

    public <T> Future<T> submit(Callable<T> task) {
        return this.submit((EventExecutor)this.next(), task);
    }
}

