/*
 * Decompiled with CFR 0.152.
 */
package cn.godmao.getty.server_websocket.client.base;

import cn.godmao.common.Init;
import cn.godmao.getty.common.GettyUtil;
import cn.godmao.getty.impl.handler.IChannelHandler;
import cn.godmao.getty.server_websocket.client.AbstractWebsocketClient;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.websocketx.WebSocketClientProtocolHandler;
import io.netty.handler.timeout.IdleStateEvent;
import java.time.LocalDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebsocketClientBaseHandler
extends ChannelInboundHandlerAdapter
implements IChannelHandler,
Init.Init1<AbstractWebsocketClient> {
    public final Logger log = LoggerFactory.getLogger(this.getClass());
    private AbstractWebsocketClient server;

    public void init(AbstractWebsocketClient server) {
        this.server = server;
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        this.server.onError(cause);
        super.exceptionCaught(ctx, cause);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.server.onClose();
        super.channelInactive(ctx);
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        this.server.onMessage(msg);
        super.channelRead(ctx, msg);
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (IdleStateEvent.FIRST_ALL_IDLE_STATE_EVENT.equals(evt)) {
            this.log.debug("FIRST_ALL_IDLE_STATE_EVENT {}", evt);
            GettyUtil.close(ctx.channel());
        } else if (IdleStateEvent.WRITER_IDLE_STATE_EVENT.equals(evt)) {
            this.log.debug("WRITER_IDLE_STATE_EVENT {} {}", (Object)LocalDateTime.now(), evt);
        } else if (IdleStateEvent.ALL_IDLE_STATE_EVENT.equals(evt)) {
            this.log.debug("ALL_IDLE_STATE_EVENT {}", evt);
        } else if (IdleStateEvent.FIRST_READER_IDLE_STATE_EVENT.equals(evt)) {
            this.log.debug("FIRST_READER_IDLE_STATE_EVENT {}", evt);
        } else if (IdleStateEvent.FIRST_WRITER_IDLE_STATE_EVENT.equals(evt)) {
            this.log.debug("FIRST_WRITER_IDLE_STATE_EVENT {}", evt);
        } else if (IdleStateEvent.READER_IDLE_STATE_EVENT.equals(evt)) {
            this.log.debug("READER_IDLE_STATE_EVENT {}", evt);
        } else if (WebSocketClientProtocolHandler.ClientHandshakeStateEvent.HANDSHAKE_COMPLETE.equals(evt)) {
            this.log.debug("HANDSHAKE_COMPLETE_EVENT {}", evt);
            this.server.onOpen();
        } else if (WebSocketClientProtocolHandler.ClientHandshakeStateEvent.HANDSHAKE_TIMEOUT.equals(evt)) {
            this.log.debug("HANDSHAKE_TIMEOUT_EVENT {}", evt);
        } else if (WebSocketClientProtocolHandler.ClientHandshakeStateEvent.HANDSHAKE_ISSUED.equals(evt)) {
            this.log.debug("HANDSHAKE_ISSUED_EVENT {}", evt);
        } else {
            this.log.debug("IDLE_STATE_EVENT {}", evt);
        }
        super.userEventTriggered(ctx, evt);
    }
}

