/*
 * Decompiled with CFR 0.152.
 */
package cn.godmao.getty.server_websocket.client;

import cn.godmao.getty.impl.IConfig;
import cn.godmao.getty.impl.codec.IDecoder;
import cn.godmao.getty.impl.codec.IEncoder;
import cn.godmao.getty.impl.handler.IChannelHandler;
import cn.godmao.getty.impl.handler.IDecoderHandler;
import cn.godmao.getty.impl.handler.IEncoderHandler;
import cn.godmao.getty.impl.handler.IFilterHandler;
import cn.godmao.getty.server_websocket.client.WebsocketClientInitializer;
import cn.godmao.getty.server_websocket.client.base.WebsocketClientBaseDecoder;
import cn.godmao.getty.server_websocket.client.base.WebsocketClientBaseDecoderHandler;
import cn.godmao.getty.server_websocket.client.base.WebsocketClientBaseEncoder;
import cn.godmao.getty.server_websocket.client.base.WebsocketClientBaseEncoderHandler;
import cn.godmao.getty.server_websocket.client.base.WebsocketClientBaseHandler;
import cn.godmao.utils.CollectUtil;
import io.netty.channel.Channel;
import io.netty.channel.ChannelInitializer;
import io.netty.util.concurrent.EventExecutorGroup;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;

public class WebsocketClientConfig
implements IConfig {
    private String host;
    private Integer port;
    private String uri;
    private Integer workTheard = 1;
    private String workTheardName = "c-work";
    private Boolean addIdleHandler = false;
    private Boolean addUnpacker = true;
    private EventExecutorGroup encoderHandlerLoopGroup;
    private EventExecutorGroup decoderHandlerLoopGroup;
    private EventExecutorGroup serviceHandlerLoopGroup;
    private Class<? extends IEncoder<?, ?>> encoderClass = WebsocketClientBaseEncoder.class;
    private Class<? extends IDecoder<?, ?>> decoderClass = WebsocketClientBaseDecoder.class;
    private Class<? extends ChannelInitializer<Channel>> channelInitializerClass = WebsocketClientInitializer.class;
    private Collection<Class<? extends IChannelHandler>> channelHandlerClass = CollectUtil.listOf((Object[])new Class[]{WebsocketClientBaseHandler.class});
    private Collection<Class<? extends IFilterHandler>> filterHandlerClass = CollectUtil.listOf((Object[])new Class[0]);
    private Collection<Class<? extends IDecoderHandler>> decoderHandlerClass = CollectUtil.listOf((Object[])new Class[]{WebsocketClientBaseDecoderHandler.class});
    private Collection<Class<? extends IEncoderHandler>> encoderHandlerClass = CollectUtil.listOf((Object[])new Class[]{WebsocketClientBaseEncoderHandler.class});
    private Collection<Class<?>> messageClass = new ArrayList();

    public WebsocketClientConfig(String uri) {
        this.uri = uri;
        URI uri_ = URI.create(uri);
        this.host = uri_.getHost();
        this.port = uri_.getPort() == -1 ? 443 : uri_.getPort();
    }

    @Override
    public Boolean getAddIdleHandler() {
        return this.addIdleHandler;
    }

    @Override
    public Boolean getAddUnpacker() {
        return this.addUnpacker;
    }

    @Override
    public Class<? extends IEncoder<?, ?>> getEncoderClass() {
        return this.encoderClass;
    }

    @Override
    public Class<? extends IDecoder<?, ?>> getDecoderClass() {
        return this.decoderClass;
    }

    public Class<? extends ChannelInitializer<Channel>> getChannelInitializerClass() {
        return this.channelInitializerClass;
    }

    @Override
    public Collection<Class<? extends IFilterHandler>> getFilterHandlerClass() {
        return this.filterHandlerClass;
    }

    @Override
    public Collection<Class<? extends IDecoderHandler>> getDecoderHandlerClass() {
        return this.decoderHandlerClass;
    }

    @Override
    public Collection<Class<? extends IEncoderHandler>> getEncoderHandlerClass() {
        return this.encoderHandlerClass;
    }

    @Override
    public Collection<Class<? extends IChannelHandler>> getChannelHandlerClass() {
        return this.channelHandlerClass;
    }

    public String getHost() {
        return this.host;
    }

    public Integer getPort() {
        return this.port;
    }

    public String getUri() {
        return this.uri;
    }

    public Integer getWorkTheard() {
        return this.workTheard;
    }

    public String getWorkTheardName() {
        return this.workTheardName;
    }

    public void setWorkTheard(Integer workTheard) {
        this.workTheard = workTheard;
    }

    public void setWorkTheardName(String workTheardName) {
        this.workTheardName = workTheardName;
    }

    @Override
    public EventExecutorGroup getEncoderHandlerLoopGroup() {
        return this.encoderHandlerLoopGroup;
    }

    public void setEncoderHandlerLoopGroup(EventExecutorGroup encoderHandlerLoopGroup) {
        this.encoderHandlerLoopGroup = encoderHandlerLoopGroup;
    }

    @Override
    public EventExecutorGroup getDecoderHandlerLoopGroup() {
        return this.decoderHandlerLoopGroup;
    }

    public void setDecoderHandlerLoopGroup(EventExecutorGroup decoderHandlerLoopGroup) {
        this.decoderHandlerLoopGroup = decoderHandlerLoopGroup;
    }

    @Override
    public EventExecutorGroup getServiceHandlerLoopGroup() {
        return this.serviceHandlerLoopGroup;
    }

    public void setServiceHandlerLoopGroup(EventExecutorGroup serviceHandlerLoopGroup) {
        this.serviceHandlerLoopGroup = serviceHandlerLoopGroup;
    }

    @Override
    public Collection<Class<?>> getMessageClass() {
        return this.messageClass;
    }
}

