/*
 * Decompiled with CFR 0.152.
 */
package cn.godmao.getty.server.server.base;

import cn.godmao.common.Init;
import cn.godmao.getty.common.GettyUtil;
import cn.godmao.getty.impl.channel.IChannel;
import cn.godmao.getty.impl.handler.IChannelHandler;
import cn.godmao.getty.server.server.AbstractServer;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.timeout.IdleStateEvent;
import java.time.LocalDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerBaseHandler
extends ChannelInboundHandlerAdapter
implements IChannelHandler,
Init.Init1<AbstractServer<IChannel<?>>> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private AbstractServer<IChannel<?>> abstractServer;
    private IChannel<?> channel;

    public void init(AbstractServer<IChannel<?>> abstractServer) {
        this.abstractServer = abstractServer;
    }

    private IChannel<?> getChannel(ChannelHandlerContext ctx) throws Exception {
        if (null == this.channel) {
            this.channel = this.abstractServer.getChannelService().get(ctx);
        }
        return this.channel;
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        IChannel<?> channel = this.getChannel(ctx);
        channel.execute(() -> this.abstractServer.onOpen(channel));
        super.channelActive(ctx);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        IChannel<?> channel = this.getChannel(ctx);
        channel.execute(() -> this.abstractServer.onError(channel, cause));
        super.exceptionCaught(ctx, cause);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        IChannel<?> channel = this.getChannel(ctx);
        channel.execute(() -> this.abstractServer.onClose(channel));
        super.channelInactive(ctx);
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        IChannel<?> channel = this.getChannel(ctx);
        channel.execute(() -> this.abstractServer.onMessage(channel, msg));
        super.channelRead(ctx, msg);
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (IdleStateEvent.FIRST_ALL_IDLE_STATE_EVENT.equals(evt)) {
            this.log.debug("FIRST_ALL_IDLE_STATE_EVENT {}", evt);
            GettyUtil.close(ctx.channel());
        } else if (IdleStateEvent.WRITER_IDLE_STATE_EVENT.equals(evt)) {
            this.log.debug("WRITER_IDLE_STATE_EVENT {} {}", (Object)LocalDateTime.now(), evt);
        } else if (IdleStateEvent.ALL_IDLE_STATE_EVENT.equals(evt)) {
            this.log.debug("ALL_IDLE_STATE_EVENT {}", evt);
        } else if (IdleStateEvent.FIRST_READER_IDLE_STATE_EVENT.equals(evt)) {
            this.log.debug("FIRST_READER_IDLE_STATE_EVENT {}", evt);
        } else if (IdleStateEvent.FIRST_WRITER_IDLE_STATE_EVENT.equals(evt)) {
            this.log.debug("FIRST_WRITER_IDLE_STATE_EVENT {}", evt);
        } else if (IdleStateEvent.READER_IDLE_STATE_EVENT.equals(evt)) {
            this.log.debug("READER_IDLE_STATE_EVENT {}", evt);
        } else {
            this.log.debug("IDLE_STATE_EVENT {}", evt);
        }
        super.userEventTriggered(ctx, evt);
    }
}

