package cn.godmao.getty.server.base;

import cn.godmao.common.Init;
import cn.godmao.getty.GettyCommon;
import cn.godmao.getty.channel.IChannel;
import cn.godmao.getty.handler.IChannelHandler;
import cn.godmao.getty.server.AbstractServer;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.timeout.IdleStateEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.time.LocalDateTime;

public class WebsocketServerBaseHandler extends ChannelInboundHandlerAdapter implements IChannelHandler, Init.Init1<AbstractServer<IChannel<?>>> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private AbstractServer<IChannel<?>> abstractServer;
    private IChannel<?> channel;

    @Override
    public void init(AbstractServer<IChannel<?>> abstractServer) {
        this.abstractServer = abstractServer;
    }

    private IChannel<?> getChannel(ChannelHandlerContext ctx) throws Exception {
        if (null == this.channel) {
            this.channel = abstractServer.getChannelService().get(ctx);
        }
        return this.channel;
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        IChannel<?> channel = getChannel(ctx);
        channel.execute(() -> abstractServer.onOpen(channel));
        super.channelActive(ctx);
    }


    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        IChannel<?> channel = getChannel(ctx);
        channel.execute(() -> abstractServer.onError(channel, cause));
        super.exceptionCaught(ctx, cause);
    }


    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        IChannel<?> channel = getChannel(ctx);
        channel.execute(() -> abstractServer.onClose(channel));
        super.channelInactive(ctx);
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        IChannel<?> channel = getChannel(ctx);
        channel.execute(() -> abstractServer.onMessage(channel, msg));
        super.channelRead(ctx, msg);
    }


    @Override
    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (IdleStateEvent.FIRST_ALL_IDLE_STATE_EVENT.equals(evt)) {
            log.debug("FIRST_ALL_IDLE_STATE_EVENT {}", evt);
            GettyCommon.close(ctx.channel());
        } else if (IdleStateEvent.WRITER_IDLE_STATE_EVENT.equals(evt)) {
            log.debug("WRITER_IDLE_STATE_EVENT {} {}", LocalDateTime.now(), evt);
        } else if (IdleStateEvent.ALL_IDLE_STATE_EVENT.equals(evt)) {
            log.debug("ALL_IDLE_STATE_EVENT {}", evt);
        } else if (IdleStateEvent.FIRST_READER_IDLE_STATE_EVENT.equals(evt)) {
            log.debug("FIRST_READER_IDLE_STATE_EVENT {}", evt);
        } else if (IdleStateEvent.FIRST_WRITER_IDLE_STATE_EVENT.equals(evt)) {
            log.debug("FIRST_WRITER_IDLE_STATE_EVENT {}", evt);
        } else if (IdleStateEvent.READER_IDLE_STATE_EVENT.equals(evt)) {
            log.debug("READER_IDLE_STATE_EVENT {}", evt);
        } else {
            log.debug("IDLE_STATE_EVENT {}", evt);
        }
        super.userEventTriggered(ctx, evt);
    }
}